/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.launcher.MobileApplicationNavigation;
import org.teamapps.application.server.system.localization.SessionApplicationLocalizationProvider;
import org.teamapps.application.server.system.privilege.PrivilegeApplicationKey;
import org.teamapps.application.server.system.privilege.UserPrivileges;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.SessionUserImpl;
import org.teamapps.icons.Icon;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.User;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.session.SessionContext;

public class UserSessionData {
    private final User user;
    private final SessionContext context;
    private final SystemRegistry registry;
    private final RootPanel rootPanel;
    private UserPrivileges userPrivileges;
    private final SessionUser sessionUser;
    private final SessionIconProvider iconProvider;
    private final List<String> localizationRankedLanguages;
    private final Map<Application, ApplicationLocalizationProvider> localizationProviderByApplication = new HashMap<Application, ApplicationLocalizationProvider>();
    private Supplier<ApplicationDesktop> applicationDesktopSupplier;
    private Function<Component, Component> rootWrapperComponentFunction;
    private final ApplicationLocalizationProvider localizationProvider;

    public UserSessionData(User user, SessionContext context, SystemRegistry registry, RootPanel rootPanel) {
        this.user = user;
        this.context = context;
        this.registry = registry;
        this.rootPanel = rootPanel;
        this.userPrivileges = new UserPrivileges(user, registry);
        this.sessionUser = new SessionUserImpl(user, context);
        this.localizationRankedLanguages = this.createLocalizationRankedLanguages();
        this.iconProvider = context.getIconProvider();
        this.localizationProvider = new SessionApplicationLocalizationProvider(null, this.localizationRankedLanguages, registry.getGlobalLocalizationProvider());
    }

    private List<String> createLocalizationRankedLanguages() {
        HashSet languages = new HashSet(this.sessionUser.getRankedLanguages());
        if (!languages.contains("en")) {
            ArrayList<String> rankedLanguages = new ArrayList<String>(this.sessionUser.getRankedLanguages());
            rankedLanguages.add("en");
            return rankedLanguages;
        }
        return this.sessionUser.getRankedLanguages();
    }

    public ManagedApplicationSessionData createManageApplicationSessionData(ManagedApplication managedApplication, MobileApplicationNavigation mobileNavigation) {
        return new ManagedApplicationSessionData(this, managedApplication, mobileNavigation);
    }

    public ApplicationPrivilegeProvider getApplicationPrivilegeProvider(ManagedApplication managedApplication) {
        return this.getUserPrivileges().getApplicationPrivilegeProvider(PrivilegeApplicationKey.create(managedApplication));
    }

    public ApplicationLocalizationProvider getApplicationLocalizationProvider(Application application) {
        if (!this.localizationProviderByApplication.containsKey(application)) {
            ApplicationLocalizationProvider applicationLocalizationProvider = this.createApplicationLocalizationProvider(application);
            this.localizationProviderByApplication.put(application, applicationLocalizationProvider);
        }
        return this.localizationProviderByApplication.get(application);
    }

    private ApplicationLocalizationProvider createApplicationLocalizationProvider(Application application) {
        return new SessionApplicationLocalizationProvider(application, this.localizationRankedLanguages, this.registry.getGlobalLocalizationProvider());
    }

    public Icon<?, ?> decodeIcon(String name) {
        if (name == null) {
            return null;
        }
        try {
            return this.context.getIconProvider().decodeIcon(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public User getUser() {
        return this.user;
    }

    public SessionContext getContext() {
        return this.context;
    }

    public SystemRegistry getRegistry() {
        return this.registry;
    }

    public RootPanel getRootPanel() {
        return this.rootPanel;
    }

    public void setRooWrapperComponentFunction(Function<Component, Component> rootWrapperComponentFunction) {
        this.rootWrapperComponentFunction = rootWrapperComponentFunction;
        this.rootPanel.setContent(rootWrapperComponentFunction.apply(this.rootPanel.getContent()));
    }

    public void setRootComponent(Component component) {
        if (this.rootWrapperComponentFunction != null) {
            this.rootPanel.setContent(this.rootWrapperComponentFunction.apply(component));
        } else {
            this.rootPanel.setContent(component);
        }
    }

    public SessionUser getSessionUser() {
        return this.sessionUser;
    }

    public SessionIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public ApplicationLocalizationProvider getLocalizationProvider() {
        return this.localizationProvider;
    }

    public UserPrivileges getUserPrivileges() {
        return this.userPrivileges;
    }

    public void invalidate() {
        this.userPrivileges = null;
    }

    public List<String> getRankedLanguages() {
        return this.sessionUser.getRankedLanguages();
    }

    public Supplier<ApplicationDesktop> getApplicationDesktopSupplier() {
        return this.applicationDesktopSupplier;
    }

    public void setApplicationDesktopSupplier(Supplier<ApplicationDesktop> applicationDesktopSupplier) {
        this.applicationDesktopSupplier = applicationDesktopSupplier;
    }
}

