/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Country;
import org.teamapps.model.controlcenter.Currency;
import org.teamapps.model.controlcenter.Language;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbCountry
extends AbstractUdbEntity<Country>
implements Country {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static TextIndex isoCode;
    protected static TextIndex icon;
    protected static TextIndex englishDisplayName;
    protected static SingleReferenceIndex localizationKey;
    protected static TextIndex addressFormat;
    protected static SingleReferenceIndex mainLanguage;
    protected static MultiReferenceIndex otherLanguages;
    protected static SingleReferenceIndex currency;
    protected static MultiReferenceIndex otherCurrencies;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getColumnIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getColumnIndex("metaRestoredBy");
        isoCode = (TextIndex)tableIndex.getColumnIndex("isoCode");
        icon = (TextIndex)tableIndex.getColumnIndex("icon");
        englishDisplayName = (TextIndex)tableIndex.getColumnIndex("englishDisplayName");
        localizationKey = (SingleReferenceIndex)tableIndex.getColumnIndex("localizationKey");
        addressFormat = (TextIndex)tableIndex.getColumnIndex("addressFormat");
        mainLanguage = (SingleReferenceIndex)tableIndex.getColumnIndex("mainLanguage");
        otherLanguages = (MultiReferenceIndex)tableIndex.getColumnIndex("otherLanguages");
        currency = (SingleReferenceIndex)tableIndex.getColumnIndex("currency");
        otherCurrencies = (MultiReferenceIndex)tableIndex.getColumnIndex("otherCurrencies");
    }

    public static List<Country> getAll() {
        return new EntityBitSetList(Country.getBuilder(), table.getRecordBitSet());
    }

    public static List<Country> getDeletedRecords() {
        return new EntityBitSetList(Country.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Country> sort(List<Country> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbCountry.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<Country> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbCountry.sort((TableIndex)table, Country.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbCountry() {
        super(table);
    }

    public UdbCountry(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public Country build() {
        return new UdbCountry();
    }

    public Country build(int id) {
        return new UdbCountry(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public Country setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public Country setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public Country setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public Country setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public Country setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public Country setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public Country setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public Country setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public Country setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public Country setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public Country setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public Country setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public Country setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public Country setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public Country setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public Country setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public String getIsoCode() {
        return this.getTextValue(isoCode);
    }

    @Override
    public Country setIsoCode(String value) {
        this.setTextValue(value, isoCode);
        return this;
    }

    @Override
    public String getIcon() {
        return this.getTextValue(icon);
    }

    @Override
    public Country setIcon(String value) {
        this.setTextValue(value, icon);
        return this;
    }

    @Override
    public String getEnglishDisplayName() {
        return this.getTextValue(englishDisplayName);
    }

    @Override
    public Country setEnglishDisplayName(String value) {
        this.setTextValue(value, englishDisplayName);
        return this;
    }

    @Override
    public LocalizationKey getLocalizationKey() {
        if (this.isChanged((ColumnIndex)localizationKey)) {
            return (LocalizationKey)this.getReferenceChangeValue((ColumnIndex)localizationKey);
        }
        int id = localizationKey.getValue(this.getId());
        if (id > 0) {
            return LocalizationKey.getById(id);
        }
        return null;
    }

    @Override
    public Country setLocalizationKey(LocalizationKey value) {
        this.setSingleReferenceValue(localizationKey, value, table);
        return this;
    }

    @Override
    public String getAddressFormat() {
        return this.getTextValue(addressFormat);
    }

    @Override
    public Country setAddressFormat(String value) {
        this.setTextValue(value, addressFormat);
        return this;
    }

    @Override
    public Language getMainLanguage() {
        if (this.isChanged((ColumnIndex)mainLanguage)) {
            return (Language)this.getReferenceChangeValue((ColumnIndex)mainLanguage);
        }
        int id = mainLanguage.getValue(this.getId());
        if (id > 0) {
            return Language.getById(id);
        }
        return null;
    }

    @Override
    public Country setMainLanguage(Language value) {
        this.setSingleReferenceValue(mainLanguage, value, table);
        return this;
    }

    @Override
    public List<Language> getOtherLanguages() {
        return this.getMultiReferenceValue(otherLanguages, Language.getBuilder());
    }

    @Override
    public Country setOtherLanguages(List<Language> value) {
        this.setMultiReferenceValue(value, otherLanguages);
        return this;
    }

    @Override
    public int getOtherLanguagesCount() {
        return this.getMultiReferenceValueCount(otherLanguages, Language.getBuilder());
    }

    @Override
    public Country setOtherLanguages(Language ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), otherLanguages);
        return this;
    }

    @Override
    public BitSet getOtherLanguagesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(otherLanguages, Language.getBuilder());
    }

    @Override
    public Country addOtherLanguages(List<Language> value) {
        this.addMultiReferenceValue(value, otherLanguages);
        return this;
    }

    @Override
    public Country addOtherLanguages(Language ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), otherLanguages);
        return this;
    }

    @Override
    public Country removeOtherLanguages(List<Language> value) {
        this.removeMultiReferenceValue(value, otherLanguages);
        return this;
    }

    @Override
    public Country removeOtherLanguages(Language ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), otherLanguages);
        return this;
    }

    @Override
    public Country removeAllOtherLanguages() {
        this.removeAllMultiReferenceValue(otherLanguages);
        return this;
    }

    @Override
    public Currency getCurrency() {
        if (this.isChanged((ColumnIndex)currency)) {
            return (Currency)this.getReferenceChangeValue((ColumnIndex)currency);
        }
        int id = currency.getValue(this.getId());
        if (id > 0) {
            return Currency.getById(id);
        }
        return null;
    }

    @Override
    public Country setCurrency(Currency value) {
        this.setSingleReferenceValue(currency, value, table);
        return this;
    }

    @Override
    public List<Currency> getOtherCurrencies() {
        return this.getMultiReferenceValue(otherCurrencies, Currency.getBuilder());
    }

    @Override
    public Country setOtherCurrencies(List<Currency> value) {
        this.setMultiReferenceValue(value, otherCurrencies);
        return this;
    }

    @Override
    public int getOtherCurrenciesCount() {
        return this.getMultiReferenceValueCount(otherCurrencies, Currency.getBuilder());
    }

    @Override
    public Country setOtherCurrencies(Currency ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), otherCurrencies);
        return this;
    }

    @Override
    public BitSet getOtherCurrenciesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(otherCurrencies, Currency.getBuilder());
    }

    @Override
    public Country addOtherCurrencies(List<Currency> value) {
        this.addMultiReferenceValue(value, otherCurrencies);
        return this;
    }

    @Override
    public Country addOtherCurrencies(Currency ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), otherCurrencies);
        return this;
    }

    @Override
    public Country removeOtherCurrencies(List<Currency> value) {
        this.removeMultiReferenceValue(value, otherCurrencies);
        return this;
    }

    @Override
    public Country removeOtherCurrencies(Currency ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), otherCurrencies);
        return this;
    }

    @Override
    public Country removeAllOtherCurrencies() {
        this.removeAllMultiReferenceValue(otherCurrencies);
        return this;
    }

    public UdbCountry save(Transaction transaction, boolean strictChangeVerification) {
        this.saveRecord(transaction, strictChangeVerification);
        return this;
    }

    public UdbCountry saveTransactional(boolean strictChangeVerification) {
        this.saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    public UdbCountry save() {
        this.saveRecord();
        return this;
    }

    public void delete(Transaction transaction) {
        this.deleteRecord(transaction);
    }

    public void delete() {
        this.deleteRecord();
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord();
    }
}

