package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface SystemSettings extends Entity<SystemSettings> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ALLOWED_BASE_LANGUAGES = "allowedBaseLanguages";

    static SystemSettings create() {
        return new UdbSystemSettings();
    }

    static SystemSettings create(int id) {
        return new UdbSystemSettings(id, true);
    }

    static SystemSettings getById(int id) {
        return new UdbSystemSettings(id, false);
    }

    static EntityBuilder<SystemSettings> getBuilder() {
        return new UdbSystemSettings(0, false);
    }

    Instant getMetaCreationDate();

    SystemSettings setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    SystemSettings setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    SystemSettings setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    SystemSettings setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    SystemSettings setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    SystemSettings setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    SystemSettings setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    SystemSettings setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    SystemSettings setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    SystemSettings setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    SystemSettings setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    SystemSettings setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    SystemSettings setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    SystemSettings setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    SystemSettings setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    SystemSettings setMetaRestoredBy(int value);

    String getAllowedBaseLanguages();

    SystemSettings setAllowedBaseLanguages(String value);


    static List<SystemSettings> getAll() {
        return UdbSystemSettings.getAll();
    }

    static List<SystemSettings> getDeletedRecords() {
        return UdbSystemSettings.getDeletedRecords();
    }

    static List<SystemSettings> sort(List<SystemSettings> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbSystemSettings.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbSystemSettings.getCount();
    }

    static SystemSettingsQuery filter() {
        return new UdbSystemSettingsQuery();
    }
}

