package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationVersionDataQuery extends AbstractUdbQuery<ApplicationVersionData> implements ApplicationVersionDataQuery {

    public UdbApplicationVersionDataQuery() {
        super(UdbApplicationVersionData.table, ApplicationVersionData.getBuilder());
    }

	@Override
	public ApplicationVersionDataQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationVersionData.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationVersionData.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationVersionData.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationVersionData.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationVersionData.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationVersionData.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationVersionData.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationVersionData.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationVersionData.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationVersionData.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationVersionData.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationVersionData.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationVersionData.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationVersionData.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplicationVersionData.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplicationVersionData.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplicationVersionData.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplicationVersionData.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery data(TextFilter filter) {
		and(UdbApplicationVersionData.data.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orData(TextFilter filter) {
		or(UdbApplicationVersionData.data.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery dataRows(NumericFilter filter) {
		and(UdbApplicationVersionData.dataRows.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orDataRows(NumericFilter filter) {
		or(UdbApplicationVersionData.dataRows.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery dataAdded(TextFilter filter) {
		and(UdbApplicationVersionData.dataAdded.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orDataAdded(TextFilter filter) {
		or(UdbApplicationVersionData.dataAdded.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery dataAddedRows(NumericFilter filter) {
		and(UdbApplicationVersionData.dataAddedRows.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orDataAddedRows(NumericFilter filter) {
		or(UdbApplicationVersionData.dataAddedRows.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery dataRemoved(TextFilter filter) {
		and(UdbApplicationVersionData.dataRemoved.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orDataRemoved(TextFilter filter) {
		or(UdbApplicationVersionData.dataRemoved.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery dataRemovedRows(NumericFilter filter) {
		and(UdbApplicationVersionData.dataRemovedRows.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionDataQuery orDataRemovedRows(NumericFilter filter) {
		or(UdbApplicationVersionData.dataRemovedRows.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationVersionDataQuery andOr(ApplicationVersionDataQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationVersionDataQuery customFilter(Function<ApplicationVersionData, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationVersionData.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



