package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbGroupFolder extends AbstractUdbEntity<GroupFolder> implements GroupFolder {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex group;
	protected static TextIndex name;
	protected static BooleanIndex moderatorReadAccess;
	protected static BooleanIndex moderatorWriteAccess;
	protected static TextIndex subjectTags;
	protected static ShortIndex groupFolderType;
	protected static MultiReferenceIndex messages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		group = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_GROUP);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		moderatorReadAccess = (BooleanIndex) tableIndex.getColumnIndex(FIELD_MODERATOR_READ_ACCESS);
		moderatorWriteAccess = (BooleanIndex) tableIndex.getColumnIndex(FIELD_MODERATOR_WRITE_ACCESS);
		subjectTags = (TextIndex) tableIndex.getColumnIndex(FIELD_SUBJECT_TAGS);
		groupFolderType = (ShortIndex) tableIndex.getColumnIndex(FIELD_GROUP_FOLDER_TYPE);
		messages = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MESSAGES);
    }

    public static List<GroupFolder> getAll() {
        return new EntityBitSetList<>(GroupFolder.getBuilder(), table.getRecordBitSet());
    }

    public static List<GroupFolder> getDeletedRecords() {
        return new EntityBitSetList<>(GroupFolder.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<GroupFolder> sort(List<GroupFolder> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<GroupFolder> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, GroupFolder.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbGroupFolder() {
        super(table);
    }

    public UdbGroupFolder(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public GroupFolder build() {
        return new UdbGroupFolder();
    }

    @Override
    public GroupFolder build(int id) {
        return new UdbGroupFolder(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public GroupFolder setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public GroupFolder setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public GroupFolder setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public GroupFolder setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public GroupFolder setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public GroupFolder setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public GroupFolder setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public GroupFolder setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public GroupFolder setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public GroupFolder setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public GroupFolder setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public GroupFolder setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public GroupFolder setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public GroupFolder setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public GroupFolder setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public GroupFolder setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Group getGroup() {
		if (isChanged(group)) {
			return (Group) getReferenceChangeValue(group);
		} else {
			int id = group.getValue(getId());
			if (id > 0) {
				return Group.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public GroupFolder setGroup(Group value) {
		setSingleReferenceValue(group, value, table);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public GroupFolder setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public boolean getModeratorReadAccess() {
	    return getBooleanValue(moderatorReadAccess);
	}

	@Override
	public GroupFolder setModeratorReadAccess(boolean value) {
	    setBooleanValue(value, this.moderatorReadAccess);
		return this;
	}

	@Override
	public boolean isModeratorReadAccess() {
	    return getBooleanValue(moderatorReadAccess);
	}

	@Override
	public boolean getModeratorWriteAccess() {
	    return getBooleanValue(moderatorWriteAccess);
	}

	@Override
	public GroupFolder setModeratorWriteAccess(boolean value) {
	    setBooleanValue(value, this.moderatorWriteAccess);
		return this;
	}

	@Override
	public boolean isModeratorWriteAccess() {
	    return getBooleanValue(moderatorWriteAccess);
	}

	@Override
	public String getSubjectTags() {
        return getTextValue(subjectTags);
	}

	@Override
	public GroupFolder setSubjectTags(String value) {
	    setTextValue(value, this.subjectTags);
		return this;
	}

	@Override
	public GroupFolderType getGroupFolderType() {
	    return getEnumValue(groupFolderType, GroupFolderType.values());
	}

	@Override
	public GroupFolder setGroupFolderType(GroupFolderType value) {
    	setEnumValue(this.groupFolderType, value);
		return this;
	}

	@Override
	public List<Message> getMessages() {
	    return getMultiReferenceValue(messages, Message.getBuilder());
	}

	@Override
	public GroupFolder setMessages(List<Message> value) {
		setMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public int getMessagesCount() {
	    return getMultiReferenceValueCount(messages, Message.getBuilder());
	}

	@Override
	public GroupFolder setMessages(Message ... value) {
		setMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public BitSet getMessagesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(messages, Message.getBuilder());
	}

	@Override
	public GroupFolder addMessages(List<Message> value) {
		addMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public GroupFolder addMessages(Message ... value) {
		addMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public GroupFolder removeMessages(List<Message> value) {
		removeMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public GroupFolder removeMessages(Message ... value) {
		removeMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public GroupFolder removeAllMessages() {
		removeAllMultiReferenceValue(messages);
		return this;
	}


    @Override
    public UdbGroupFolder save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroupFolder saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbGroupFolder save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



