package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserAcceptedPolicyEntriesQuery extends AbstractUdbQuery<UserAcceptedPolicyEntries> implements UserAcceptedPolicyEntriesQuery {

    public UdbUserAcceptedPolicyEntriesQuery() {
        super(UdbUserAcceptedPolicyEntries.table, UserAcceptedPolicyEntries.getBuilder());
    }

	@Override
	public UserAcceptedPolicyEntriesQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserAcceptedPolicyEntries.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserAcceptedPolicyEntries.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaModificationDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery acceptedPrivacyPolicy(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.acceptedPrivacyPolicy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orAcceptedPrivacyPolicy(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.acceptedPrivacyPolicy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery acceptedTermsOfUse(NumericFilter filter) {
		and(UdbUserAcceptedPolicyEntries.acceptedTermsOfUse.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyEntriesQuery orAcceptedTermsOfUse(NumericFilter filter) {
		or(UdbUserAcceptedPolicyEntries.acceptedTermsOfUse.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserAcceptedPolicyEntriesQuery andOr(UserAcceptedPolicyEntriesQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserAcceptedPolicyEntriesQuery customFilter(Function<UserAcceptedPolicyEntries, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserAcceptedPolicyEntries.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



