package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserAcceptedPolicyEntries extends Entity<UserAcceptedPolicyEntries> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ACCEPTED_PRIVACY_POLICY = "acceptedPrivacyPolicy";
	final static String FIELD_ACCEPTED_TERMS_OF_USE = "acceptedTermsOfUse";

    static UserAcceptedPolicyEntries create() {
        return new UdbUserAcceptedPolicyEntries();
    }

    static UserAcceptedPolicyEntries create(int id) {
        return new UdbUserAcceptedPolicyEntries(id, true);
    }

    static UserAcceptedPolicyEntries getById(int id) {
        return new UdbUserAcceptedPolicyEntries(id, false);
    }

    static EntityBuilder<UserAcceptedPolicyEntries> getBuilder() {
        return new UdbUserAcceptedPolicyEntries(0, false);
    }

    Instant getMetaCreationDate();

    UserAcceptedPolicyEntries setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    UserAcceptedPolicyEntries setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    UserAcceptedPolicyEntries setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    UserAcceptedPolicyEntries setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    UserAcceptedPolicyEntries setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    UserAcceptedPolicyEntries setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    UserAcceptedPolicyEntries setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    UserAcceptedPolicyEntries setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    UserAcceptedPolicyEntries setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserAcceptedPolicyEntries setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserAcceptedPolicyEntries setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserAcceptedPolicyEntries setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    UserAcceptedPolicyEntries setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    UserAcceptedPolicyEntries setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    UserAcceptedPolicyEntries setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    UserAcceptedPolicyEntries setMetaRestoredBy(int value);

    int getAcceptedPrivacyPolicy();

    UserAcceptedPolicyEntries setAcceptedPrivacyPolicy(int value);

    int getAcceptedTermsOfUse();

    UserAcceptedPolicyEntries setAcceptedTermsOfUse(int value);


    static List<UserAcceptedPolicyEntries> getAll() {
        return UdbUserAcceptedPolicyEntries.getAll();
    }

    static List<UserAcceptedPolicyEntries> getDeletedRecords() {
        return UdbUserAcceptedPolicyEntries.getDeletedRecords();
    }

    static List<UserAcceptedPolicyEntries> sort(List<UserAcceptedPolicyEntries> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserAcceptedPolicyEntries.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserAcceptedPolicyEntries.getCount();
    }

    static UserAcceptedPolicyEntriesQuery filter() {
        return new UdbUserAcceptedPolicyEntriesQuery();
    }
}

