/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class OrganizationUnitTypePerspective
extends AbstractManagedApplicationPerspective {
    public OrganizationUnitTypePerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.ELEMENTS_CASCADE, this.getLocalized("organizationUnitType.organizationUnitTypes"), this.getApplicationInstanceData(), OrganizationUnitType::filter, Privileges.ORGANIZATION_UNIT_TYPE_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        entityModelBuilder.updateModels();
        TemplateField unitTypeField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        TemplateField abbreviationField = TranslatableTextUtils.createTranslatableTemplateField((ApplicationInstanceData)this.getApplicationInstanceData());
        TemplateField defaultChildField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        TagComboBox allowedChildTypesField = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("name", this.getLocalized("organizationUnitType.organizationUnitType"), (AbstractField)unitTypeField).setDefaultWidth(170));
        table.addColumn(new TableColumn("abbreviation", this.getLocalized("organizationUnitType.abbreviation"), (AbstractField)abbreviationField).setDefaultWidth(80));
        table.addColumn(new TableColumn("defaultChildType", this.getLocalized("organizationUnitType.defaultChildType"), (AbstractField)defaultChildField).setDefaultWidth(130));
        table.addColumn(new TableColumn("possibleChildrenTypes", this.getLocalized("organizationUnitType.allowedChildrenTypes"), (AbstractField)allowedChildTypesField).setDefaultWidth(350));
        table.setPropertyExtractor((unitType, propertyName) -> switch (propertyName) {
            case "name" -> unitType;
            case "abbreviation" -> unitType.getAbbreviation();
            case "defaultChildType" -> unitType.getDefaultChildType();
            case "possibleChildrenTypes" -> unitType.getPossibleChildrenTypes();
            default -> null;
        });
        TranslatableField translatableNameField = TranslatableTextUtils.createTranslatableField((ApplicationInstanceData)this.getApplicationInstanceData());
        TranslatableField translatableAbbreviationField = TranslatableTextUtils.createTranslatableField((ApplicationInstanceData)this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (boolean)true);
        iconComboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        CheckBox translateOrgUnitsCheckBox = new CheckBox(this.getLocalized("organizationUnitType.translateOrganizationUnits"));
        CheckBox allowAsUsersCheckBox = new CheckBox(this.getLocalized("organizationUnitType.allowUsers"));
        ComboBox<OrganizationUnitType> defaultChildTypeCombo = this.createOrgUnitTypeComboBox();
        TagComboBox<OrganizationUnitType> possibleChildrenTagCombo = OrganizationUtils.createOrganizationUnitTypeTagComboBox(50, this.getApplicationInstanceData());
        ComboBox<GeoLocationType> geoLocationComboBox = this.createGeoLocationComboBox();
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.typeTitle"), (AbstractField)translatableNameField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.abbreviation"), (AbstractField)translatableAbbreviationField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.icon"), (AbstractField)iconComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.translateUnits"), (AbstractField)translateOrgUnitsCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.allowUsers"), (AbstractField)allowAsUsersCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.defaultChildType"), defaultChildTypeCombo);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.allowedChildrenTypes"), possibleChildrenTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.geoLocationType"), geoLocationComboBox);
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        formController.addNotNull((AbstractField)translatableNameField);
        formController.addNotNull(geoLocationComboBox);
        formController.setSaveEntityHandler(organizationUnitType -> {
            OrganizationUnitType type = (OrganizationUnitType)entityModelBuilder.getSelectedRecord();
            if (type != null && translatableNameField.getValue() != null && geoLocationComboBox.getValue() != null) {
                type.setName(translatableNameField.getValue()).setAbbreviation(translatableAbbreviationField.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))).setTranslateOrganizationUnits((Boolean)translateOrgUnitsCheckBox.getValue()).setAllowUsers((Boolean)allowAsUsersCheckBox.getValue()).setDefaultChildType((OrganizationUnitType)defaultChildTypeCombo.getValue()).setPossibleChildrenTypes((List)possibleChildrenTagCombo.getValue()).setGeoLocationType((GeoLocationType)((Object)((Object)geoLocationComboBox.getValue())));
                return true;
            }
            return false;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(type -> {
            translatableNameField.setValue(type.getName());
            translatableAbbreviationField.setValue(type.getAbbreviation());
            iconComboBox.setValue((Object)IconUtils.decodeIcon((String)type.getIcon()));
            translateOrgUnitsCheckBox.setValue((Object)type.getTranslateOrganizationUnits());
            allowAsUsersCheckBox.setValue((Object)type.isAllowUsers());
            defaultChildTypeCombo.setValue((Object)type.getDefaultChildType());
            possibleChildrenTagCombo.setValue(type.getPossibleChildrenTypes());
            geoLocationComboBox.setValue((Object)type.getGeoLocationType());
        });
        entityModelBuilder.setSelectedRecord((Object)OrganizationUnitType.create());
    }

    private ComboBox<OrganizationUnitType> createOrgUnitTypeComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitType.getAll().stream().limit(50L).collect(Collectors.toList()) : OrganizationUnitType.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        return comboBox;
    }

    private ComboBox<GeoLocationType> createGeoLocationComboBox() {
        PropertyProvider propertyProvider = (type, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", type != GeoLocationType.NONE ? ApplicationIcons.MAP_LOCATION : ApplicationIcons.SIGN_FORBIDDEN);
            map.put("caption", this.getLocalized("organizationUnitType.geoLocationType." + type.name()));
            return map;
        };
        return ComboBoxUtils.createRecordComboBox(Arrays.asList(GeoLocationType.values()), (PropertyProvider)propertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }
}

