/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.roles;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.RoleUtils;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class RolesPerspective
extends AbstractManagedApplicationPerspective {
    public RolesPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        Supplier<Query> querySupplier = () -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())) : Role.filter();
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.WORKER, this.getLocalized("roles.roles"), this.getApplicationInstanceData(), querySupplier, Privileges.ROLES_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        entityModelBuilder.updateModels();
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField organizationFieldTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()));
        TagComboBox allowedOrganizationUnitTypesTableField = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        CheckBox noDirectMembershipsTableField = new CheckBox(this.getLocalized("roles.noDirectMemberships"));
        table.addColumn(new TableColumn("title", this.getLocalized("org.teamapps.dictionary.name"), (AbstractField)roleTableField).setDefaultWidth(200));
        if (!this.isAppFilter()) {
            table.addColumn(new TableColumn("organizationField", this.getLocalized("organizationField.organizationField"), (AbstractField)organizationFieldTableField).setDefaultWidth(130));
        }
        table.addColumn(new TableColumn("allowedOrganizationUnitTypes", this.getLocalized("roles.allowedOrganizationUnitTypes"), (AbstractField)allowedOrganizationUnitTypesTableField).setDefaultWidth(350));
        table.addColumn(new TableColumn("noDirectMemberships", this.getLocalized("roles.noMemberships"), (AbstractField)noDirectMembershipsTableField).setDefaultWidth(200));
        table.setPropertyExtractor((role, propertyName) -> switch (propertyName) {
            case "title" -> role;
            case "organizationField" -> role.getOrganizationField();
            case "allowedOrganizationUnitTypes" -> role.getAllowedOrganizationUnitTypes();
            case "noDirectMemberships" -> role.getNoDirectMemberships();
            default -> null;
        });
        TranslatableField titleField = TranslatableTextUtils.createTranslatableField((ApplicationInstanceData)this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox();
        ComboBox parentRoleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        TagComboBox<OrganizationUnitType> allowedOrganizationUnitTypesTagCombo = this.createOrgUnitTypeTagComboBox();
        ComboBox organizationFieldComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Collections.singletonList(this.getOrganizationField()) : OrganizationField.getAll(), PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        TagComboBox<Role> generalizationRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> specializationRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> privilegesReceivingRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> privilegesSendingRolesTagCombo = this.createRoleTagComboBox();
        CheckBox noDirectMembershipsCheckBox = new CheckBox(this.getLocalized("roles.noDirectMemberships"));
        EntityListModelBuilder userRoleAssignmentModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData(), userRoleAssignment -> userRoleAssignment.getUser().getFirstName() + " " + userRoleAssignment.getUser().getLastName());
        Table roleMemberTable = userRoleAssignmentModelBuilder.createListTable(true);
        roleMemberTable.setHideHeaders(true);
        TemplateField userTemplateField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        TemplateField organizationUnitTemplateField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        roleMemberTable.addColumn(new TableColumn("user", (AbstractField)userTemplateField));
        roleMemberTable.addColumn(new TableColumn("orgUnit", (AbstractField)organizationUnitTemplateField));
        roleMemberTable.setPropertyExtractor((userRoleAssignment, propertyName) -> switch (propertyName) {
            case "user" -> userRoleAssignment.getUser();
            case "orgUnit" -> userRoleAssignment.getOrganizationUnit();
            default -> null;
        });
        FormPanel roleMembersPanel = new FormPanel(this.getApplicationInstanceData());
        roleMembersPanel.setTable(roleMemberTable, (RecordModelBuilder)userRoleAssignmentModelBuilder, ApplicationIcons.USERS, this.getLocalized("users.users"), true, false, false);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("roles.role"), (AbstractField)titleField);
        formLayout.addLabelAndField(null, this.getLocalized("roles.icon"), (AbstractField)iconComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("roles.parentRole"), (AbstractField)parentRoleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("roles.allowedOrganizationUnitTypes"), allowedOrganizationUnitTypesTagCombo);
        if (!this.isOrgFieldFilterApplied()) {
            formLayout.addLabelAndField(null, this.getLocalized("roles.organizationField"), (AbstractField)organizationFieldComboBox);
        }
        formLayout.addLabelAndField(null, this.getLocalized("roles.generalizationRoles"), generalizationRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.specializationRoles"), specializationRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.privilegesReceivingRoles"), privilegesReceivingRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.privilegesSendingRoles"), privilegesSendingRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.noMemberships"), (AbstractField)noDirectMembershipsCheckBox);
        formLayout.addSection(ApplicationIcons.USERS_CROWD, this.getLocalized("roles.members"));
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.privileges"), (Component)roleMembersPanel.getPanel());
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        formController.addNotNull((AbstractField)titleField);
        formController.addNotNull((AbstractField)iconComboBox);
        formController.setSaveEntityHandler(role -> {
            OrganizationField organizationField = this.isOrgFieldFilterApplied() ? this.getOrganizationField() : (OrganizationField)organizationFieldComboBox.getValue();
            role.setTitle(titleField.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))).setParent((Role)parentRoleComboBox.getValue()).setAllowedOrganizationUnitTypes((List)allowedOrganizationUnitTypesTagCombo.getValue()).setOrganizationField(organizationField).setGeneralizationRoles((List)generalizationRolesTagCombo.getValue()).setSpecializationRoles((List)specializationRolesTagCombo.getValue()).setPrivilegesReceivingRoles((List)privilegesReceivingRolesTagCombo.getValue()).setPrivilegesSendingRoles((List)privilegesSendingRolesTagCombo.getValue()).setNoDirectMemberships((Boolean)noDirectMembershipsCheckBox.getValue());
            return true;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(role -> {
            titleField.setValue(role.getTitle());
            iconComboBox.setValue((Object)IconUtils.decodeIcon((String)role.getIcon()));
            parentRoleComboBox.setValue((Object)role.getParent());
            allowedOrganizationUnitTypesTagCombo.setValue(role.getAllowedOrganizationUnitTypes());
            organizationFieldComboBox.setValue((Object)role.getOrganizationField());
            generalizationRolesTagCombo.setValue(role.getGeneralizationRoles());
            specializationRolesTagCombo.setValue(role.getSpecializationRoles());
            privilegesReceivingRolesTagCombo.setValue(role.getPrivilegesReceivingRoles());
            privilegesSendingRolesTagCombo.setValue(role.getPrivilegesSendingRoles());
            noDirectMembershipsCheckBox.setValue((Object)role.getNoDirectMemberships());
            userRoleAssignmentModelBuilder.setRecords(RoleUtils.getMembers(role, true));
        });
        entityModelBuilder.setSelectedRecord((Object)Role.create());
    }

    private TagComboBox<Role> createRoleTagComboBox() {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? (this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll().stream().limit(50L).collect(Collectors.toList())) : (this.isAppFilter() ? Role.filter().parseFullTextFilter(query, new String[0]).organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.filter().parseFullTextFilter(query, new String[0]).execute()));
        PropertyProvider<Role> propertyProvider = PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData());
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }

    private TagComboBox<OrganizationUnitType> createOrgUnitTypeTagComboBox() {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitType.getAll().stream().limit(50L).collect(Collectors.toList()) : OrganizationUnitType.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }
}

