/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.privilege.PrivilegeApplicationKey;
import org.teamapps.application.server.system.privilege.UserPrivileges;
import org.teamapps.application.tools.RecordListModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.PropertyData;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.application.ux.org.OrganizationTree;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class UserPrivilegesView
extends AbstractApplicationView {
    private final UserPrivileges userPrivileges;
    private Map<Privilege, Set<OrganizationUnitView>> privilegeOrgUnitsMap;
    private ResponsiveForm<?> responsiveForm;

    public UserPrivilegesView(UserPrivileges userPrivileges, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.userPrivileges = userPrivileges;
        this.createUi();
    }

    private void createUi() {
        this.responsiveForm = new ResponsiveForm(100, 200, 0);
        ResponsiveFormLayout formLayout = this.responsiveForm.addResponsiveFormLayout(1000);
        Map<Application, List<PrivilegeApplicationKey>> applicationKeyMap = this.userPrivileges.getApplicationKeyMap();
        ArrayList treeNodes = new ArrayList();
        applicationKeyMap.entrySet().stream().sorted((o1, o2) -> this.getLocalized(((Application)o1.getKey()).getTitleKey(), new Object[0]).compareTo(((Application)o2.getKey()).getTitleKey())).forEach(entry -> {
            PrivilegeNode appNode = new PrivilegeNode((Application)entry.getKey(), null);
            treeNodes.add(appNode);
            List privilegeKeys = (List)entry.getValue();
            for (PrivilegeApplicationKey privilegeApplicationKey : privilegeKeys) {
                PrivilegeNode parent = appNode;
                if (privilegeKeys.size() > 1) {
                    OrganizationFieldView organizationFieldView = privilegeApplicationKey.getOrganizationFieldView();
                    parent = new PrivilegeNode(organizationFieldView, appNode);
                    treeNodes.add(parent);
                }
                List<PrivilegeGroup> privilegeGroups = this.userPrivileges.getPrivilegeGroups(privilegeApplicationKey);
                for (PrivilegeGroup privilegeGroup : privilegeGroups) {
                    treeNodes.add(new PrivilegeNode(privilegeGroup, privilegeApplicationKey, parent));
                }
            }
        });
        ListTreeModel listTreeModel = new ListTreeModel(treeNodes);
        listTreeModel.setTreeNodeInfoFunction(node -> node);
        Tree tree = new Tree((TreeModel)listTreeModel);
        tree.setPropertyProvider((node, propertyNames) -> PropertyData.create((Icon)node.getIcon(), (String)node.getTitle(), (String)node.getTitle()));
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        FormPanel mainFormPanel = new FormPanel(this.getApplicationInstanceData(), (Component)tree);
        mainFormPanel.setHeight(500);
        RecordListModelBuilder privilegeModelBuilder = new RecordListModelBuilder(this.getApplicationInstanceData(), privilege -> this.getLocalized(privilege.getTitleKey(), new Object[0]));
        Table privilegeTable = privilegeModelBuilder.createListTable(true);
        FormPanel privilegeFormPanel = new FormPanel(this.getApplicationInstanceData());
        privilegeFormPanel.setTable(privilegeTable, true, false, false);
        OrganizationTree organizationTree = new OrganizationTree(this.getApplicationInstanceData());
        FormPanel organizationPanel = new FormPanel(this.getApplicationInstanceData(), (Component)organizationTree.getTree());
        organizationPanel.setHeight(400);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndComponent(null, null, (Component)mainFormPanel.getPanel());
        formLayout.addLabelAndComponent(null, null, (Component)privilegeFormPanel.getPanel());
        formLayout.addLabelAndComponent(null, null, (Component)organizationPanel.getPanel());
        privilegeFormPanel.getPanel().setVisible(false);
        organizationPanel.getPanel().setVisible(false);
        privilegeTable.onRowSelected.addListener(privilege -> {
            if (this.privilegeOrgUnitsMap != null) {
                Set<OrganizationUnitView> organizationUnitViews = this.privilegeOrgUnitsMap.get(privilege);
                organizationTree.setOrganizationUnits(organizationUnitViews);
            }
        });
        tree.onNodeSelected.addListener(node -> {
            PrivilegeGroup privilegeGroup = node.getPrivilegeGroup();
            this.privilegeOrgUnitsMap = null;
            if (privilegeGroup == null) {
                privilegeFormPanel.getPanel().setVisible(false);
                organizationPanel.getPanel().setVisible(false);
            } else {
                PrivilegeApplicationKey applicationKey = node.getPrivilegeApplicationKey();
                if (privilegeGroup instanceof SimplePrivilege) {
                    SimplePrivilege privilege = (SimplePrivilege)privilegeGroup;
                    privilegeFormPanel.getPanel().setVisible(false);
                    organizationPanel.getPanel().setVisible(false);
                } else if (privilegeGroup instanceof SimpleOrganizationalPrivilege) {
                    SimpleOrganizationalPrivilege privilege = (SimpleOrganizationalPrivilege)privilegeGroup;
                    Set<OrganizationUnitView> organizationUnitViews = this.userPrivileges.getSimpleOrganizationPrivilegeMap().get(applicationKey).get(privilege);
                    organizationTree.setOrganizationUnits(organizationUnitViews);
                    privilegeFormPanel.getPanel().setVisible(false);
                    organizationPanel.getPanel().setVisible(true);
                } else if (privilegeGroup instanceof SimpleCustomObjectPrivilege) {
                    SimpleCustomObjectPrivilege privilege = (SimpleCustomObjectPrivilege)privilegeGroup;
                    privilegeFormPanel.getPanel().setVisible(false);
                    organizationPanel.getPanel().setVisible(false);
                } else if (privilegeGroup instanceof StandardPrivilegeGroup) {
                    StandardPrivilegeGroup privilege = (StandardPrivilegeGroup)privilegeGroup;
                    Set<Privilege> privileges = this.userPrivileges.getStandardPrivilegeMap().get(applicationKey).get(privilege);
                    privilegeModelBuilder.setRecords(new ArrayList<Privilege>(privileges));
                    privilegeFormPanel.getPanel().setVisible(true);
                    organizationPanel.getPanel().setVisible(false);
                } else if (privilegeGroup instanceof OrganizationalPrivilegeGroup) {
                    OrganizationalPrivilegeGroup privilege = (OrganizationalPrivilegeGroup)privilegeGroup;
                    this.privilegeOrgUnitsMap = this.userPrivileges.getOrganizationPrivilegeGroupMap().get(applicationKey).get(privilege);
                    Set<Privilege> privileges = this.privilegeOrgUnitsMap.keySet();
                    privilegeModelBuilder.setRecords(new ArrayList<Privilege>(privileges));
                    organizationTree.setOrganizationUnits(Collections.emptyList());
                    privilegeFormPanel.getPanel().setVisible(true);
                    organizationPanel.getPanel().setVisible(true);
                } else if (privilegeGroup instanceof CustomObjectPrivilegeGroup) {
                    CustomObjectPrivilegeGroup privilege = (CustomObjectPrivilegeGroup)privilegeGroup;
                    Map<Privilege, Set<PrivilegeObject>> privilegeSetMap = this.userPrivileges.getCustomObjectPrivilegeGroupMap().get(applicationKey).get(privilege);
                    privilegeModelBuilder.setRecords(new ArrayList<Privilege>(privilegeSetMap.keySet()));
                    privilegeFormPanel.getPanel().setVisible(true);
                    organizationPanel.getPanel().setVisible(false);
                }
            }
        });
    }

    public UserPrivileges getUserPrivileges() {
        return this.userPrivileges;
    }

    public ResponsiveForm<?> getResponsiveForm() {
        return this.responsiveForm;
    }

    public class PrivilegeNode
    implements TreeNodeInfo {
        private Application application;
        private OrganizationFieldView organizationField;
        private PrivilegeGroup privilegeGroup;
        private final PrivilegeNode parent;
        private PrivilegeApplicationKey privilegeApplicationKey;

        public PrivilegeNode(Application application, PrivilegeNode parent) {
            this.application = application;
            this.parent = parent;
        }

        public PrivilegeNode(OrganizationFieldView organizationField, PrivilegeNode parent) {
            this.organizationField = organizationField;
            this.parent = parent;
        }

        public PrivilegeNode(PrivilegeGroup privilegeGroup, PrivilegeApplicationKey privilegeApplicationKey, PrivilegeNode parent) {
            this.privilegeGroup = privilegeGroup;
            this.privilegeApplicationKey = privilegeApplicationKey;
            this.parent = parent;
        }

        public PrivilegeApplicationKey getPrivilegeApplicationKey() {
            return this.privilegeApplicationKey;
        }

        public Icon getIcon() {
            if (this.application != null) {
                return IconUtils.decodeIcon((String)this.application.getIcon());
            }
            if (this.organizationField != null) {
                return IconUtils.decodeIcon((String)this.organizationField.getIcon());
            }
            if (this.privilegeGroup != null) {
                return this.privilegeGroup.getIcon();
            }
            return ApplicationIcons.WINDOWS;
        }

        public String getTitle() {
            if (this.application != null) {
                return UserPrivilegesView.this.getLocalized(this.application.getTitleKey(), new Object[0]);
            }
            if (this.organizationField != null) {
                return UserPrivilegesView.this.getLocalized(this.organizationField.getTitle());
            }
            if (this.privilegeGroup != null) {
                return UserPrivilegesView.this.getLocalized(this.privilegeGroup.getTitleKey(), new Object[0]);
            }
            return UserPrivilegesView.this.getLocalized("org.teamapps.dictionary.applications", new Object[0]);
        }

        public Application getApplication() {
            return this.application;
        }

        public OrganizationFieldView getOrganizationField() {
            return this.organizationField;
        }

        public PrivilegeGroup getPrivilegeGroup() {
            return this.privilegeGroup;
        }

        public Object getParent() {
            return this.parent;
        }

        public boolean isExpanded() {
            return false;
        }

        public boolean isLazyChildren() {
            return false;
        }
    }
}

