/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCodeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCodeExtractor.class);
    private static final String TEAMAPPS_CLIENT_FILE_NAME = "teamapps-client.zip";
    private static final String TEAMAPPS_CLIENT_CHECKSUM_FILE_NAME = "teamapps-client.zip.MD5";

    public static void initializeWebserverDirectory(File webAppDirectory) throws IOException {
        File currentlyDeployedChecksumFile = new File(webAppDirectory, TEAMAPPS_CLIENT_CHECKSUM_FILE_NAME);
        String currentlyDeployedArtifactChecksum = currentlyDeployedChecksumFile.exists() ? IOUtils.toString((URI)currentlyDeployedChecksumFile.toURI()).trim() : null;
        String[] currentlyDeployedFiles = webAppDirectory.list((dir, name) -> !name.startsWith("."));
        if (currentlyDeployedArtifactChecksum == null && currentlyDeployedFiles != null && currentlyDeployedFiles.length > 0) {
            LOGGER.warn("Checksum file not present (teamapps-client.zip.MD5) but directory not empty!. Will NOT refresh the webapp directory since this is probably a development environment. If not, consider cleaning up the directory!");
            return;
        }
        URL checksumResourceUrl = ClientCodeExtractor.class.getResource("/teamapps-client.zip.MD5");
        String artifactChecksum = checksumResourceUrl != null ? IOUtils.toString((URL)checksumResourceUrl).trim() : null;
        LOGGER.info("Checksum of currently deployed artifact (" + webAppDirectory.getAbsolutePath() + "): " + currentlyDeployedArtifactChecksum);
        LOGGER.info("Checksum of executed artifact: " + artifactChecksum);
        if (!Objects.equals(currentlyDeployedArtifactChecksum, artifactChecksum)) {
            ClientCodeExtractor.overwriteWebappDirectory(webAppDirectory, currentlyDeployedChecksumFile, checksumResourceUrl);
        } else {
            LOGGER.info("Checksum has not changed. Nothing to do.");
        }
    }

    private static void overwriteWebappDirectory(File webAppDirectory, File currentlyDeployedChecksumFile, URL checksumResourceUrl) throws IOException {
        FileOutputStream out;
        boolean deleted;
        if (webAppDirectory.exists() && !(deleted = webAppDirectory.delete())) {
            LOGGER.error("Could not delete webapp directory!");
        }
        webAppDirectory.mkdirs();
        File tempFile = File.createTempFile("teamapps-client", "zip");
        try (InputStream in = ClientCodeExtractor.class.getResourceAsStream("/teamapps-client.zip");){
            out = new FileOutputStream(tempFile);
            try {
                LOGGER.info("Extracting teamapps-client.zip from classpath to temp file: " + tempFile.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        LOGGER.info("Unzipping " + tempFile.getAbsolutePath() + " to " + webAppDirectory.getAbsolutePath());
        ClientCodeExtractor.unzipFile(tempFile, webAppDirectory);
        in = checksumResourceUrl.openStream();
        try {
            out = new FileOutputStream(currentlyDeployedChecksumFile);
            try {
                LOGGER.info("Writing checksum to " + currentlyDeployedChecksumFile.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static boolean unzipFile(File file, File destinationDir) {
        try {
            if (file == null || !file.exists() || destinationDir == null || !destinationDir.isDirectory()) {
                return false;
            }
            ZipFile zipFile = new ZipFile(file);
            zipFile.extractAll(destinationDir.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

