import { UiComponent } from "./UiComponent";
import { UiPieChart_DataPointClickedEvent, UiPieChartCommandHandler, UiPieChartConfig, UiPieChartEventSource } from "../generated/UiPieChartConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiChartNamedDataPointConfig } from "../generated/UiChartNamedDataPointConfig";
import { UiDataPointWeighting } from '../generated/UiDataPointWeighting';
import { UiChartLegendStyle } from "../generated/UiChartLegendStyle";
export declare class UiPieChart extends UiComponent<UiPieChartConfig> implements UiPieChartCommandHandler, UiPieChartEventSource {
    readonly onDataPointClicked: TeamAppsEvent<UiPieChart_DataPointClickedEvent>;
    chart: any;
    config: UiPieChartConfig;
    constructor(config: UiPieChartConfig, context: TeamAppsUiContext);
    createChart(): void;
    getMainDomElement(): JQuery<HTMLElement>;
    onResize(): void;
    setDataPoints(dataPoints: UiChartNamedDataPointConfig[], animationDuration: number): void;
    setDataPointWeighting(dataPointWeighting: UiDataPointWeighting): void;
    setHeight3D(height3D: number): void;
    setInnerRadiusProportion(innerRadiusProportion: number): void;
    setLegendStyle(legendStyle: UiChartLegendStyle): void;
    setRotation3D(rotation3D: number): void;
    setRotationClockwise(rotationClockwise: number): void;
}
export interface PatternifyParameter {
    selector: string;
    tag: string;
    data?: any;
}
export interface PieChartAttributes {
    [key: string]: any;
    data: UiPieChartConfig;
    svgWidth: number;
    svgHeight: number;
    marginTop: number;
    marginBottom: number;
    marginRight: number;
    marginLeft: number;
    container: any;
    defaultTextFill: string;
    defaultFont: string;
    onDataPointClicked: (name: string) => void;
}
