import { UiComponent } from "./UiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { ScaleTime } from "d3-scale";
import { UiScaleType } from "../generated/UiScaleType";
import { UiTimeGraphDataPointConfig } from "../generated/UiTimeGraphDataPointConfig";
import { UiTimeGraph_DataNeededEvent, UiTimeGraph_IntervalSelectedEvent, UiTimeGraph_ZoomedEvent, UiTimeGraphCommandHandler, UiTimeGraphConfig, UiTimeGraphEventSource } from "../generated/UiTimeGraphConfig";
import { UiLongIntervalConfig } from "../generated/UiLongIntervalConfig";
import { UiLineChartLineFormatConfig } from "../generated/UiLineChartLineFormatConfig";
import { UiLineChartYScaleZoomMode } from "../generated/UiLineChartYScaleZoomMode";
import { UiLineChartMouseScrollZoomPanMode } from "../generated/UiLineChartMouseScrollZoomPanMode";
import { UiTimeChartZoomLevelConfig } from "../generated/UiTimeChartZoomLevelConfig";
export declare class UiTimeGraph extends UiComponent<UiTimeGraphConfig> implements UiTimeGraphCommandHandler, UiTimeGraphEventSource {
    readonly onDataNeeded: TeamAppsEvent<UiTimeGraph_DataNeededEvent>;
    readonly onIntervalSelected: TeamAppsEvent<UiTimeGraph_IntervalSelectedEvent>;
    readonly onZoomed: TeamAppsEvent<UiTimeGraph_ZoomedEvent>;
    static readonly LOGSCALE_MIN_Y: number;
    static readonly DROP_SHADOW_ID: string;
    private mouseScrollZoomPanMode;
    private intervalX;
    private maxPixelsBetweenDataPoints;
    private seriesById;
    private $main;
    private $svg;
    private $rootG;
    private $dropShadowFilter;
    private $clipPath;
    private scaleX;
    private dropShadowFilterId;
    private margin;
    private zoom;
    private xAxis;
    private $xAxis;
    private $horizontalPanRect;
    private zoomLevelIntervalManagers;
    private brush;
    private $brush;
    private $graphClipContainer;
    private xSelection;
    private $yZeroLine;
    private zoomLevels;
    private $yAxisContainer;
    private lastDrawableWidth;
    private readonly drawableWidth;
    private readonly drawableHeight;
    private readonly marginLeft;
    constructor(config: UiTimeGraphConfig, context: TeamAppsUiContext);
    private createAndAddSeries;
    getZoomBoundsX(): number[];
    getTransformedScaleX(): ScaleTime<number, number>;
    private initZoomLevelIntervalManagers;
    private redraw;
    private restrictDomainXToConfiguredInterval;
    getCurrentZoomLevel(): number;
    private getSortedZoomLevels;
    private handleBrushSelection;
    onResize(): void;
    private updateZoomExtents;
    private getAllSeries;
    addData(zoomLevel: number, intervalX: UiLongIntervalConfig, data: {
        [seriesId: string]: UiTimeGraphDataPointConfig[];
    }): void;
    resetAllData(newZoomLevels: UiTimeChartZoomLevelConfig[]): void;
    replaceAllData(newZoomLevels: UiTimeChartZoomLevelConfig[], zoomLevel: number, intervalX: UiLongIntervalConfig, data: {
        [seriesId: string]: UiTimeGraphDataPointConfig[];
    }): void;
    setIntervalX(intervalX: UiLongIntervalConfig): void;
    setIntervalY(lineId: string, intervalY: UiLongIntervalConfig): void;
    setYScaleZoomMode(lineId: string, yScaleZoomMode: UiLineChartYScaleZoomMode): void;
    setMouseScrollZoomPanMode(mouseScrollZoomPanMode: UiLineChartMouseScrollZoomPanMode): void;
    private fireUiZoomEvent;
    setYScaleType(lineId: string, yScaleType: UiScaleType): void;
    setSelectedInterval(intervalX: UiLongIntervalConfig): void;
    setMaxPixelsBetweenDataPoints(maxPixelsBetweenDataPoints: number): void;
    destroy(): void;
    getMainDomElement(): JQuery;
    private calculateMaxZoomFactor;
    setLineFormats(lineFormats: {
        [lineId: string]: UiLineChartLineFormatConfig;
    }): void;
}
