/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCodeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCodeExtractor.class);
    private static final String TEAMAPPS_CLIENT_FILE_NAME = "teamapps-client.zip";
    private static final String TEAMAPPS_CLIENT_CHECKSUM_FILE_NAME = "teamapps-client.zip.MD5";
    public static final String TEAMAPPS_CLIENT_CHECKSUM_RESOURCE_NAME = "/teamapps-client.zip.MD5";

    public static void initializeWebserverDirectory(File webAppDirectory) throws IOException {
        File currentlyDeployedChecksumFile = new File(webAppDirectory, TEAMAPPS_CLIENT_CHECKSUM_FILE_NAME);
        String currentlyDeployedArtifactChecksum = currentlyDeployedChecksumFile.exists() ? IOUtils.toString((InputStream)new FileInputStream(currentlyDeployedChecksumFile), (Charset)StandardCharsets.UTF_8).trim() : null;
        String[] currentlyDeployedFiles = webAppDirectory.list((dir, name) -> !name.startsWith("."));
        if (currentlyDeployedArtifactChecksum == null && currentlyDeployedFiles != null && currentlyDeployedFiles.length > 0) {
            LOGGER.warn("Checksum file not present (teamapps-client.zip.MD5) but directory not empty!. Will NOT refresh the webapp directory since this is probably a development environment. If not, consider cleaning up the directory!");
            return;
        }
        URL checksumResourceUrl = ClientCodeExtractor.class.getResource(TEAMAPPS_CLIENT_CHECKSUM_RESOURCE_NAME);
        String artifactChecksum = checksumResourceUrl != null ? IOUtils.toString((URL)checksumResourceUrl, (Charset)StandardCharsets.UTF_8).trim() : null;
        LOGGER.info("Checksum of currently deployed artifact (" + webAppDirectory.getAbsolutePath() + "): " + currentlyDeployedArtifactChecksum);
        LOGGER.info("Checksum of executed artifact: " + artifactChecksum);
        if (!Objects.equals(currentlyDeployedArtifactChecksum, artifactChecksum)) {
            ClientCodeExtractor.overwriteWebappDirectory(webAppDirectory, currentlyDeployedChecksumFile);
        } else {
            LOGGER.info("Checksum has not changed. Nothing to do.");
        }
    }

    private static void overwriteWebappDirectory(File webAppDirectory, File currentlyDeployedChecksumFile) throws IOException {
        FileOutputStream out;
        if (webAppDirectory.exists()) {
            FileUtils.deleteDirectory((File)webAppDirectory);
        }
        webAppDirectory.mkdirs();
        File tempFile = File.createTempFile("teamapps-client", "zip");
        try (InputStream in = ClientCodeExtractor.class.getResourceAsStream("/teamapps-client.zip");){
            out = new FileOutputStream(tempFile);
            try {
                LOGGER.info("Extracting teamapps-client.zip from classpath to temp file: " + tempFile.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        LOGGER.info("Unzipping " + tempFile.getAbsolutePath() + " to " + webAppDirectory.getAbsolutePath());
        ClientCodeExtractor.unzipFile(tempFile, webAppDirectory);
        String newChecksum = ClientCodeExtractor.readResourceAsStringOrNull(TEAMAPPS_CLIENT_CHECKSUM_RESOURCE_NAME);
        out = new FileOutputStream(currentlyDeployedChecksumFile);
        try {
            LOGGER.info("Writing checksum to " + currentlyDeployedChecksumFile.getAbsolutePath());
            IOUtils.write((String)newChecksum, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        finally {
            out.close();
        }
    }

    private static void unzipFile(File zipFile, File destDir) throws IOException {
        Objects.requireNonNull(zipFile);
        Objects.requireNonNull(destDir);
        ClientCodeExtractor.createDirIfNotExists(destDir);
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                while (zipEntry != null) {
                    File destFile = new File(destDir, zipEntry.getName());
                    String destDirPath = destDir.getCanonicalPath();
                    String destFilePath = destFile.getCanonicalPath();
                    if (!destFilePath.startsWith(destDirPath + File.separator)) {
                        throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
                    }
                    if (zipEntry.isDirectory()) {
                        ClientCodeExtractor.createDirIfNotExists(destFile);
                    } else {
                        int len;
                        File parent = destFile.getParentFile();
                        ClientCodeExtractor.createDirIfNotExists(parent);
                        FileOutputStream fos = new FileOutputStream(destFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
            zis.closeEntry();
        }
        Files.setLastModifiedTime(destDir.toPath().resolve("index.html"), FileTime.from(Instant.now()));
    }

    private static void createDirIfNotExists(File dir) throws IOException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory " + dir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readResourceAsStringOrNull(String resourceName) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            if (is != null) {
                String string2 = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

