import { UiField } from "./UiField";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiNumberFieldCommandHandler, UiNumberFieldConfig, UiNumberFieldEventSource } from "../../generated/UiNumberFieldConfig";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiNumberFieldSliderMode } from "../../generated/UiNumberFieldSliderMode";
export declare class UiNumberField extends UiField<UiNumberFieldConfig, number> implements UiNumberFieldEventSource, UiNumberFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private $wrapper;
    private $clearableFieldWrapper;
    private $field;
    private showClearButton;
    private $slider;
    private $sliderHandle;
    private minValue;
    private maxValue;
    private sliderMode;
    private sliderStep;
    private commitOnSliderChange;
    private numberFormat;
    private numberParser;
    protected initialize(config: UiNumberFieldConfig, context: TeamAppsUiContext): void;
    private fireTextInput;
    commit(forceEvenIfNotChanged?: boolean): boolean;
    private setEditorValue;
    private setSliderPositionByValue;
    private getSliderMinMaxPositionX;
    private coerceToSteppedValue;
    private getBoundedValue;
    onResize(): void;
    private ensureDecimalInput;
    isValidData(v: number): boolean;
    private convertInputToDecimalValue;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    protected displayCommittedValue(): void;
    private formatNumber;
    getTransientValue(): number;
    focus(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: number, availableWidth: number): string;
    getDefaultValue(): number;
    setLocale(locale: string): void;
    setPrecision(precision: number): void;
    setPlaceholderText(placeholderText: string): void;
    setShowClearButton(showClearButton: boolean): void;
    private updateClearButton;
    valuesChanged(v1: number, v2: number): boolean;
    setMinValue(minValue: number): void;
    setMaxValue(maxValue: number): void;
    setSliderMode(sliderMode: UiNumberFieldSliderMode): void;
    setSliderStep(sliderStep: number): void;
    setCommitOnSliderChange(commitOnSliderChange: boolean): void;
}
