import { UiComponent } from "./UiComponent";
import { UiField } from "./formfield/UiField";
import { UiFieldConfig } from "../generated/UiFieldConfig";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
declare type ComponentClass<T extends UiComponent<UiComponentConfig>> = {
    new (config: UiComponentConfig, context: TeamAppsUiContext): T;
};
declare type FieldClass<T extends UiField> = {
    new (config: UiFieldConfig, context: TeamAppsUiContext): T;
};
export declare class TeamAppsUiComponentRegistry {
    private static logger;
    private static componentClasses;
    private static fieldClasses;
    static registerComponentClass<F extends UiComponent<UiComponentConfig>>(componentName: string, componentClass: ComponentClass<F>): void;
    static getComponentClassForName(componentName: string): ComponentClass<UiComponent<UiComponentConfig>>;
    static registerFieldClass<F extends UiField>(fieldName: string, fieldClass: FieldClass<F>): void;
    static getFieldClassForName(fieldName: string): FieldClass<UiField>;
}
export {};
