import { UiToolbar } from "./tool-container/toolbar/UiToolbar";
import { UiNavigationBar } from "./UiNavigationBar";
import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiMobileLayoutCommandHandler, UiMobileLayoutConfig } from "../generated/UiMobileLayoutConfig";
import { UiMobileLayoutAnimation } from "../generated/UiMobileLayoutAnimation";
export declare class UiMobileLayout extends UiComponent<UiMobileLayoutConfig> implements UiMobileLayoutCommandHandler {
    private $mainDiv;
    private $toolbarContainer;
    private $contentContainerWrapper;
    private $navBarContainer;
    private toolbar;
    private navBar;
    private views;
    private currentView;
    constructor(config: UiMobileLayoutConfig, context: TeamAppsUiContext);
    addView(viewComponent: UiComponent): void;
    removeView(viewId: string): void;
    showView(viewId: string, animationType: UiMobileLayoutAnimation): void;
    private doViewTransition;
    onResize(): void;
    private resizeChildren;
    setToolbar(toolbar: UiToolbar): void;
    setNavigationBar(navBar: UiNavigationBar): void;
    getMainDomElement(): JQuery;
    protected onAttachedToDom(): void;
    destroy(): void;
}
