import { UiComponent } from "./UiComponent";
import { UiPieChart_DataPointClickedEvent, UiPieChartCommandHandler, UiPieChartConfig, UiPieChartEventSource } from "../generated/UiPieChartConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiChartNamedDataPointConfig } from "../generated/UiChartNamedDataPointConfig";
import { UiColorConfig } from '../generated/UiColorConfig';
import { UiDataPointWeighting } from '../generated/UiDataPointWeighting';
import { UiChartLegendStyle } from "../generated/UiChartLegendStyle";
export declare class UiPieChart extends UiComponent<UiPieChartConfig> implements UiPieChartCommandHandler, UiPieChartEventSource {
    readonly onDataPointClicked: TeamAppsEvent<UiPieChart_DataPointClickedEvent>;
    chart: Chart;
    config: UiPieChartConfig;
    constructor(config: UiPieChartConfig, context: TeamAppsUiContext);
    createChart(): void;
    getMainDomElement(): JQuery<HTMLElement>;
    onResize(): void;
    setDataPoints(dataPoints: UiChartNamedDataPointConfig[], animationDuration: number): void;
    setDataPointWeighting(dataPointWeighting: UiDataPointWeighting): void;
    setHeight3D(height3D: number): void;
    setInnerRadiusProportion(innerRadiusProportion: number): void;
    setLegendStyle(legendStyle: UiChartLegendStyle): void;
    setRotation3D(rotation3D: number): void;
    setRotationClockwise(rotationClockwise: number): void;
}
interface Chart {
    getChartState: () => PieChartAttributes;
    svgWidth(): number;
    svgWidth(svgWidth: number): Chart;
    svgHeight(): number;
    svgHeight(svgHeight: number): Chart;
    marginTop(): number;
    marginTop(marginTop: number): Chart;
    marginBottom(): number;
    marginBottom(marginBottom: number): Chart;
    marginRight(): number;
    marginRight(marginRight: number): Chart;
    marginLeft(): number;
    marginLeft(marginLeft: number): Chart;
    container(): Element;
    container(container: Element): Chart;
    defaultTextFill(): string;
    defaultTextFill(defaultTextFill: string): Chart;
    defaultFont(): string;
    defaultFont(defaultFont: string): Chart;
    data(): UiPieChartConfig;
    data(data: UiPieChartConfig): Chart;
    duration(): number;
    duration(duration: number): Chart;
    firstRun(): boolean;
    firstRun(firstRun: boolean): Chart;
    onDataPointClicked(): (id: string) => void;
    onDataPointClicked(onDataPointClicked: (id: string) => void): Chart;
    rx(): number;
    rx(rx: number): Chart;
    ry(): number;
    ry(ry: number): Chart;
    h(): number;
    h(h: number): Chart;
    ir(): number;
    ir(ir: number): Chart;
}
declare class Chart {
    /** It feels so wrong declaring this variable
     *  We don't use it, if we have used it, it won't be in static context
     *  Basically we use this variable to make typescript compiler to not to complain about this._current usage in the static methods
     *  where 'this' is bound externally using method.bind(this) syntax
     */
    static _current: any;
    constructor();
    initializeEnterExitUpdatePattern(): void;
    render(): this;
    draw(data: PieDataObject[], { rx, ry, h, ir }: PieChartAttributes): void;
    updateData(transitionTime: number): this;
    onSliceClick(d: PieDataObject): void;
    onSliceMouseEnter(d: PieDataObject): void;
    onSliceMouseLeave(d: PieDataObject): void;
    static colorToRGBAString(color: UiColorConfig): string;
    static pieOuter(d: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): string;
    static pieInner(d: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): string;
    static pieTop(d: PieDataObject, { rx, ry, ir }: PieChartAttributes): string;
    static pieCornerSurface(d: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): string;
    static pieCorner(d: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): string;
    static textTweenTransform(a: PieDataObject, { rx, ry }: PieChartAttributes): (t: any) => string;
    static arcTweenCorner(a: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): (t: any) => string;
    static arcTweenCornerSurface(a: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): (t: any) => string;
    static arcTweenInner(a: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): (t: any) => string;
    static arcTweenTop(a: PieDataObject, { rx, ry, ir }: PieChartAttributes): (t: any) => string;
    static arcTweenOuter(a: PieDataObject, { rx, ry, h, ir }: PieChartAttributes): (t: any) => string;
}
export interface Layouts {
    [key: string]: Function;
}
export interface PieDataObject {
    value: number;
    startAngle: number;
    endAngle: number;
    data: any;
}
export interface PatternifyParameter {
    selector: string;
    tag: string;
    data?: any;
}
export interface PieChartAttributes {
    [key: string]: any;
    data?: UiPieChartConfig;
    svgWidth?: number;
    svgHeight?: number;
    marginTop?: number;
    marginBottom?: number;
    marginRight?: number;
    marginLeft?: number;
    container?: any;
    defaultTextFill?: string;
    defaultFont?: string;
    onDataPointClicked?: (name: string) => void;
    rx?: number;
    ry?: number;
    h?: number;
    ir?: number;
}
export {};
