/// <reference path="../../../ts/custom-declarations/mediaelement.d.ts" />
import "mediaelement/full";
import { UiComponent } from "./UiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiVideoPlayer_ErrorLoadingEvent, UiVideoPlayer_PlayerProgressEvent, UiVideoPlayerCommandHandler, UiVideoPlayerConfig, UiVideoPlayerEventSource } from "../generated/UiVideoPlayerConfig";
import { UiMediaPreloadMode } from "../generated/UiMediaPreloadMode";
export declare class UiVideoPlayer extends UiComponent<UiVideoPlayerConfig> implements UiVideoPlayerCommandHandler, UiVideoPlayerEventSource {
    readonly onPlayerProgress: TeamAppsEvent<UiVideoPlayer_PlayerProgressEvent>;
    readonly onErrorLoading: TeamAppsEvent<UiVideoPlayer_ErrorLoadingEvent>;
    private $componentWrapper;
    private $video;
    private mediaPlayer;
    private contentReady;
    private jumpToPositionWhenReady;
    private destroyed;
    private autoplay;
    private playState;
    constructor(config: UiVideoPlayerConfig, context: TeamAppsUiContext);
    getMainDomElement(): JQuery;
    protected onAttachedToDom(): void;
    private onContentReady;
    play(): void;
    pause(): void;
    jumpTo(seconds: number): void;
    onResize(): void;
    destroy(): void;
    setAutoplay(autoplay: boolean): void;
    setPreloadMode(preloadMode: UiMediaPreloadMode): void;
    setUrl(url: string): void;
}
