import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiLabel_ClickedEvent, UiLabelConfig, UiLabelCommandHandler, UiLabelEventSource } from "../../generated/UiLabelConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
export declare class UiLabel extends UiField<UiLabelConfig, string> implements UiLabelEventSource, UiLabelCommandHandler {
    readonly onClicked: TeamAppsEvent<UiLabel_ClickedEvent>;
    private $main;
    private $caption;
    private targetField;
    private targetFieldVisibilityChangeHandler;
    protected initialize(config: UiLabelConfig, context: TeamAppsUiContext): void;
    setTargetField(targetField: UiField): void;
    isValidData(v: string): boolean;
    setCaption(caption: string): void;
    setIcon(icon: string): void;
    getMainInnerDomElement(): JQuery;
    getFocusableElement(): JQuery;
    getTransientValue(): string;
    getDefaultValue(): string;
    protected displayCommittedValue(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    valuesChanged(v1: string, v2: string): boolean;
}
