import { UiField } from "./UiField";
import { UiFileFieldDisplayType } from "../../generated/UiFileFieldDisplayType";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFileItemConfig } from "../../generated/UiFileItemConfig";
import { UiSimpleFileField_FileItemClickedEvent, UiSimpleFileField_FileItemRemovedEvent, UiSimpleFileField_UploadCanceledEvent, UiSimpleFileField_UploadFailedEvent, UiSimpleFileField_UploadInitiatedByUserEvent, UiSimpleFileField_UploadStartedEvent, UiSimpleFileField_UploadSuccessfulEvent, UiSimpleFileField_UploadTooLargeEvent, UiSimpleFileFieldCommandHandler, UiSimpleFileFieldConfig, UiSimpleFileFieldEventSource } from "../../generated/UiSimpleFileFieldConfig";
/**
 * @author Yann Massard (yamass@gmail.com)
 */
export declare class UiSimpleFileField extends UiField<UiSimpleFileFieldConfig, UiFileItemConfig[]> implements UiSimpleFileFieldEventSource, UiSimpleFileFieldCommandHandler {
    readonly onFileItemClicked: TeamAppsEvent<UiSimpleFileField_FileItemClickedEvent>;
    readonly onFileItemRemoved: TeamAppsEvent<UiSimpleFileField_FileItemRemovedEvent>;
    readonly onUploadCanceled: TeamAppsEvent<UiSimpleFileField_UploadCanceledEvent>;
    readonly onUploadFailed: TeamAppsEvent<UiSimpleFileField_UploadFailedEvent>;
    readonly onUploadInitiatedByUser: TeamAppsEvent<UiSimpleFileField_UploadInitiatedByUserEvent>;
    readonly onUploadStarted: TeamAppsEvent<UiSimpleFileField_UploadStartedEvent>;
    readonly onUploadSuccessful: TeamAppsEvent<UiSimpleFileField_UploadSuccessfulEvent>;
    readonly onUploadTooLarge: TeamAppsEvent<UiSimpleFileField_UploadTooLargeEvent>;
    private $main;
    private $uploadButton;
    private $fileInput;
    private $fileList;
    private displayMode;
    private maxFiles;
    private fileItems;
    private maxBytesPerFile;
    private fileTooLargeMessage;
    private uploadErrorMessage;
    private uploadUrl;
    protected initialize(config: UiSimpleFileFieldConfig, context: TeamAppsUiContext): void;
    protected displayCommittedValue(): void;
    getDefaultValue(): UiFileItemConfig[];
    getFocusableElement(): JQuery;
    getMainInnerDomElement(): JQuery;
    getTransientValue(): UiFileItemConfig[];
    isValidData(v: UiFileItemConfig[]): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode?: UiFieldEditingMode): void;
    valuesChanged(v1: UiFileItemConfig[], v2: UiFileItemConfig[]): boolean;
    addFileItem(itemConfig: UiFileItemConfig, state?: FileItemState): void;
    removeFileItem(itemUuid: string): void;
    setBrowseButtonCaption(browseButtonCaption: string): void;
    setBrowseButtonIcon(browseButtonIcon: string): void;
    setDisplayMode(displayMode: UiFileFieldDisplayType): void;
    setFileTooLargeMessage(fileTooLargeMessage: string): void;
    setMaxBytesPerFile(maxBytesPerFile: number): void;
    setMaxFiles(maxFiles: number): void;
    setUploadErrorMessage(uploadErrorMessage: string): void;
    setUploadUrl(uploadUrl: string): void;
    updateFileItem(itemConfig: UiFileItemConfig): void;
    private readonly numberOfNonErrorFileItems;
    private readonly numberOfUploadingFileItems;
    private updateVisibilities;
    private resetFileInput;
    private handleFiles;
    private createUploadFileItem;
}
declare enum FileItemState {
    INITIATING = 0,
    TOO_LARGE = 1,
    UPLOADING = 2,
    FAILED = 3,
    DONE = 4
}
export {};
