import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponent } from "../UiComponent";
import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { ClickOutsideHandle } from "../Common";
import { UiSpinner } from "./UiSpinner";
export declare abstract class AbstractDropDown<OPEN_CONFIG> {
    onClose: TeamAppsEvent<void>;
    onComponentRemoved: TeamAppsEvent<UiComponent>;
    protected $dropDown: JQuery;
    protected $contentContainer: JQuery;
    protected clickOutsideHandle: ClickOutsideHandle;
    protected spinner: UiSpinner;
    protected currentOpenConfig: OPEN_CONFIG;
    private _isOpen;
    private _contentComponent;
    constructor(content?: UiComponent<UiComponentConfig>);
    setContentComponent(component: UiComponent<UiComponentConfig>): void;
    getContentComponent(): UiComponent<UiComponentConfig>;
    open(config: OPEN_CONFIG): void;
    protected abstract doOpen(config: OPEN_CONFIG): void;
    close(): void;
    protected abstract doClose(): void;
    readonly isOpen: boolean;
    getMainDomElement(): JQuery;
    getScrollContainer(): JQuery;
}
