import { ProgressIndicator } from "./ProgressIndicator";
export declare class ProgressCircle implements ProgressIndicator {
    private $mainDomElement;
    private $circle;
    private $caption;
    private circleRadius;
    private svgCircleRadius;
    private caption;
    /**
     * @param circleRadius in px
     * @param initialProgress Between 0 and 1
     * @param initialCaption
     * @param circleStrokeWidth
     * @param transitionTime
     */
    constructor(initialProgress: number, { circleRadius, circleStrokeWidth, transitionTime }: {
        circleRadius?: number;
        circleStrokeWidth?: number;
        transitionTime?: number;
    });
    /**
     * @param progress Between 0 and 1
     * @param caption
     */
    setProgress(progress: number): void;
    setErrorMessage(message: string | null): void;
    private calculateStrokeOffset;
    getMainDomElement(): JQuery<HTMLElement>;
}
