import * as moment from "moment-timezone";
import { EventObjectInput } from "fullcalendar/src/types/input-types";
import { View } from "fullcalendar";
import Moment = moment.Moment;
export declare class MultiMonthView extends View {
    private width;
    private height;
    private weekNumbersVisible;
    private $contentElement;
    private uuid;
    private _svg;
    private padding;
    private spacing;
    private monthWidth;
    private monthHeight;
    private firstDayOffsetX;
    private dayColumnWidth;
    private firstWeekLineOffset;
    private weekLineHeight;
    private maxOccupationTime;
    private events;
    private weekDayShortNames;
    initialize(): void;
    removeElement(): void;
    render(): void;
    updateSize(totalHeight: number, isAuto: boolean, isResize: boolean): void;
    renderEvents(events: EventObjectInput[]): void;
    destroyEvents(): void;
    renderSelection(range: {
        start: Moment;
        end: Moment;
    }): void;
    destroySelection(): void;
    private getMonthRangesToBeDisplayed;
    private getDisplayedWeeks;
    private getMonthsPerRow;
    renderDates(): void;
    /**
     * @deprecated use this.weekDayShortNames instead of calculating this all the time
     * @returns {any[]}
     */
    private getWeekDayShortNames;
    private calculateDayOccupationColorsFromEvents;
    private updateMonthDisplays;
    private describeArc;
    private eventsToSegments;
    private eventToSegments;
    private groupSegmentsByDay;
    private calculateDayOccupationColors;
    private getDayString;
}
