import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTabPanel } from "../UiTabPanel";
import { ItemTreeItem } from "./ItemTree";
import { UiComponent } from "../UiComponent";
import { View } from "./View";
import { SplitPaneItem } from "./SplitPaneItem";
import { UiViewGroupPanelState } from "../../generated/UiViewGroupPanelState";
declare class MinimizableTabPanel extends UiTabPanel {
    private _minimized;
    minimized: boolean;
    readonly empty: boolean;
}
export declare class TabPanelItem implements ItemTreeItem<UiTabPanel> {
    private context;
    private static logger;
    readonly id: string;
    readonly persistent: boolean;
    readonly component: MinimizableTabPanel;
    parent: SplitPaneItem | null;
    private _tabs;
    readonly tabs: View[];
    $minimizedTrayButton: JQuery;
    readonly onTabSelected: TeamAppsEvent<{
        tabPanelItemId: string;
        tabId: string;
    }>;
    readonly onTabNeedsRefresh: TeamAppsEvent<{
        tabId: string;
    }>;
    readonly onTabClosed: TeamAppsEvent<string>;
    readonly onPanelStateChangeTriggered: TeamAppsEvent<UiViewGroupPanelState>;
    private _state;
    constructor(id: string, persistent: boolean, parent: SplitPaneItem, context: TeamAppsUiContext);
    readonly itemIds: string[];
    readonly viewNames: string[];
    private createWindowButtonList;
    addTab(view: View, select: boolean, index?: number): void;
    moveTab(viewName: string, index: number): void;
    removeTab(view: View): void;
    updateTab(viewName: string, component: UiComponent<UiComponentConfig>): void;
    setTabConfiguration(viewName: string, tabIcon: string, tabCaption: string, tabCloseable: boolean, visible: boolean): void;
    selectTab(viewName: string): void;
    private updateWindowToolButtons;
    readonly maximized: boolean;
    state: UiViewGroupPanelState;
    private updateMinimizedButton;
}
export {};
