import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiConfigurationConfig } from "../../generated/UiConfigurationConfig";
import { UiWorkSpaceLayout_ChildWindowClosedEvent, UiWorkSpaceLayout_ChildWindowCreationFailedEvent, UiWorkSpaceLayout_LayoutChangedEvent, UiWorkSpaceLayout_ViewClosedEvent, UiWorkSpaceLayout_ViewDraggedToNewWindowEvent, UiWorkSpaceLayout_ViewGroupPanelStateChangedEvent, UiWorkSpaceLayout_ViewNeedsRefreshEvent, UiWorkSpaceLayout_ViewSelectedEvent, UiWorkSpaceLayoutCommandHandler, UiWorkSpaceLayoutConfig, UiWorkSpaceLayoutEventSource } from "../../generated/UiWorkSpaceLayoutConfig";
import { UiWorkSpaceLayoutViewConfig } from "../../generated/UiWorkSpaceLayoutViewConfig";
import { UiWorkSpaceLayoutItemConfig } from "../../generated/UiWorkSpaceLayoutItemConfig";
import { UiComponent } from "../UiComponent";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiSplitSizePolicy } from "../../generated/UiSplitSizePolicy";
import { UiRelativeWorkSpaceViewPosition } from "../../generated/UiRelativeWorkSpaceViewPosition";
import { WindowLayoutDescriptor } from "./WindowLayoutDescriptor";
import { UiWorkSpaceLayoutViewGroupItemConfig } from "../../generated/UiWorkSpaceLayoutViewGroupItemConfig";
import { UiWorkSpaceLayoutSplitItemConfig } from "../../generated/UiWorkSpaceLayoutSplitItemConfig";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
import { UiViewGroupPanelState } from "../../generated/UiViewGroupPanelState";
import { UiToolbar } from "../tool-container/toolbar/UiToolbar";
export declare type UiWorkspaceLayoutSubWindowProtocol_INIT_OK = {
    _type: 'INIT_OK';
    sessionId: string;
    workspaceLayoutId: string;
    windowId: string;
    uiConfiguration: UiConfigurationConfig;
    backgroundImage: string;
    blurredBackgroundImage: string;
    registeredTemplates: {
        [name: string]: UiTemplateConfig;
    };
    childWindowPageTitle: string;
};
export declare type UiWorkspaceLayoutDndDataTransfer = {
    sourceUiSessionId: string;
    sourceWorkspaceLayoutId: string;
    sourceWindowId: string;
    targetWindowId?: string;
    viewName: string;
    tabIcon: string;
    tabCaption: string;
    tabCloseable: boolean;
    lazyLoading: boolean;
    visible: boolean;
};
export declare class UiWorkSpaceLayout extends UiComponent<UiWorkSpaceLayoutConfig> implements UiWorkSpaceLayoutCommandHandler, UiWorkSpaceLayoutEventSource {
    readonly onLayoutChanged: TeamAppsEvent<UiWorkSpaceLayout_LayoutChangedEvent>;
    readonly onViewDraggedToNewWindow: TeamAppsEvent<UiWorkSpaceLayout_ViewDraggedToNewWindowEvent>;
    readonly onViewNeedsRefresh: TeamAppsEvent<UiWorkSpaceLayout_ViewNeedsRefreshEvent>;
    readonly onChildWindowCreationFailed: TeamAppsEvent<UiWorkSpaceLayout_ChildWindowCreationFailedEvent>;
    readonly onChildWindowClosed: TeamAppsEvent<UiWorkSpaceLayout_ChildWindowClosedEvent>;
    readonly onViewSelected: TeamAppsEvent<UiWorkSpaceLayout_ViewSelectedEvent>;
    readonly onViewClosed: TeamAppsEvent<UiWorkSpaceLayout_ViewClosedEvent>;
    readonly onViewGroupPanelStateChanged: TeamAppsEvent<UiWorkSpaceLayout_ViewGroupPanelStateChangedEvent>;
    static readonly ROOT_WINDOW_ID: string;
    rootWindowMessagePort: MessagePort;
    windowId: string;
    private localViewContainer;
    private viewContainersByWindowId;
    constructor(config: UiWorkSpaceLayoutConfig, context: TeamAppsUiContext, windowId?: string, rootWindowMessagePort?: MessagePort);
    private handleChildWindowCreated;
    private handleChildWindowCreationFailed;
    private handleViewDroppedFromOtherWindow;
    private handleLocalLayoutChangedByUser;
    private readonly isRootWindow;
    removeView(viewName: string): Promise<void>;
    redefineLayout(layoutsByWindowId: {
        [windowId: string]: UiWorkSpaceLayoutItemConfig;
    }, addedViews: UiWorkSpaceLayoutViewConfig[]): void;
    moveViewToTopLevel(viewName: string, targetWindowId: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): Promise<void>;
    moveViewRelativeToOtherView(viewName: string, existingViewName: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): Promise<void>;
    moveViewToNeighbourTab(viewName: string, existingViewName: string, select: boolean): Promise<void>;
    addViewToTopLevel(newView: UiWorkSpaceLayoutViewConfig, windowId: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): void;
    addViewRelativeToOtherView(newView: UiWorkSpaceLayoutViewConfig, existingViewName: string, relativePosition: UiRelativeWorkSpaceViewPosition, sizePolicy: UiSplitSizePolicy, referenceChildSize: number): Promise<void>;
    addViewAsTab(newView: UiWorkSpaceLayoutViewConfig, layoutItemId: string, select: boolean): Promise<void>;
    addViewAsNeighbourTab(newView: UiWorkSpaceLayoutViewConfig, existingViewName: string, select: boolean): Promise<void>;
    refreshViewComponent(viewName: string, component: UiComponent): Promise<void>;
    refreshViewAttributes(viewName: string, tabIcon: string, tabCaption: string, tabCloseable: boolean, visible: boolean): Promise<void>;
    selectView(viewName: string): Promise<void>;
    setViewGroupPanelState(viewGroupId: string, panelState: UiViewGroupPanelState): Promise<void>;
    private fireLayoutChanged;
    private getViewContainerByViewName;
    private extractViewNamesFromLayoutDescriptor;
    private getViewContainerByItemId;
    private extractItemIdsFromLayoutDescriptor;
    private readonly viewContainers;
    private static createEmptyViewConfig;
    onResize(): void;
    setToolbar(toolbar: UiToolbar): void;
    getCurrentLayout(): Promise<{
        [name: string]: UiWorkSpaceLayoutItemConfig;
    }>;
    getLocalLayout(): Promise<WindowLayoutDescriptor>;
    getMainDomElement(): JQuery;
    protected onAttachedToDom(): void;
    destroy(): void;
    fireViewGroupPanelStateChanged(viewGroupId: string, panelState: UiViewGroupPanelState): void;
}
export declare function isTabPanelDescriptor(item: UiWorkSpaceLayoutItemConfig): item is UiWorkSpaceLayoutViewGroupItemConfig;
export declare function isSplitPanelDescriptor(item: UiWorkSpaceLayoutItemConfig): item is UiWorkSpaceLayoutSplitItemConfig;
