import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { UiComponent } from "../UiComponent";
import { TabPanelItem } from "./TabPanelItem";
import { ViewInfo } from "./ViewInfo";
import { UiWindowButtonType } from "../../generated/UiWindowButtonType";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export declare class View implements ViewInfo {
    viewName: string;
    tabIcon: string;
    tabCaption: string;
    tabCloseable: boolean;
    lazyLoading: boolean;
    visible: boolean;
    readonly onPanelWindowButtonClicked: TeamAppsEvent<UiWindowButtonType>;
    private _parent;
    private _component;
    constructor(viewName: string, tabIcon: string, tabCaption: string, tabCloseable: boolean, lazyLoading: boolean, visible: boolean, component: UiComponent<UiComponentConfig>);
    component: UiComponent<UiComponentConfig>;
    private handlePanelWindowButtonClicked;
    updateTabAttributes(tabIcon: string, tabCaption: string, tabCloseable: boolean, visible: boolean): void;
    setVisible(visible: boolean): any;
    readonly viewInfo: ViewInfo;
    setWindowButtons(toolButtons: UiWindowButtonType[]): void;
    parent: TabPanelItem;
}
