import { NavigationDirection, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
import { LocalDateTime } from "../datetime/LocalDateTime";
export declare enum WeekDay {
    MONDAY = 1,
    TUESDAY = 2,
    WEDNESDAY = 3,
    THURSDAY = 4,
    FRIDAY = 5,
    SATURDAY = 6,
    SUNDAY = 7
}
export declare type TimeUnit = 'year' | 'month' | 'day';
export interface TrivialCalendarBoxConfig {
    locale?: string;
    selectedDate?: LocalDateTime;
    firstDayOfWeek?: WeekDay;
    highlightKeyboardNavigationState?: boolean;
}
export declare class TrivialCalendarBox implements TrivialComponent {
    private config;
    private keyboardNavigationState;
    private keyboardNavCssClass;
    private selectedDate;
    private $calendarBox;
    private $calendarDisplay;
    private $yearDisplay;
    private $monthDisplay;
    private $monthTable;
    private $year;
    private $month;
    readonly onChange: TrivialEvent<{
        value: LocalDateTime;
        timeUnitEdited: TimeUnit;
    }>;
    readonly onOnEditingTimeUnitChange: TrivialEvent<TimeUnit>;
    constructor(options?: TrivialCalendarBoxConfig);
    private getDaysForCalendarDisplay;
    private firstDayOfWeek;
    private updateDisplay;
    setSelectedDate(dateTime: LocalDateTime): void;
    setYear(year: number, fireEvent?: boolean): void;
    setMonth(month: number, fireEvent?: boolean): void;
    setDayOfMonth(day: number, fireEvent?: boolean): void;
    setMonthAndDay(month: number, day: number, fireEvent?: boolean): void;
    private fireChangeEvents;
    setKeyboardNavigationState(newKeyboardNavigationState: TimeUnit): void;
    getSelectedDate(): LocalDateTime;
    private navigateByUnit;
    navigate(direction: NavigationDirection): void;
    navigateTimeUnit(timeUnit: TimeUnit, direction: NavigationDirection): void;
    getMainDomElement(): HTMLElement;
    destroy(): void;
}
