import QrWorker = require('worker-loader!./worker');
declare type Rect = {
    x: number;
    width: number;
    y: number;
    height: number;
};
declare type ImageSource = HTMLCanvasElement | HTMLVideoElement | HTMLImageElement | URL | File | string;
export declare class QrScanner {
    private $video;
    private $canvas;
    private onDecode;
    private active;
    private paused;
    private sourceRect;
    private qrWorker;
    constructor(video: HTMLVideoElement, onDecode: (s: string) => void, canvasSize?: number);
    destroy(): void;
    start(deviceId?: string): Promise<void>;
    stop(): void;
    pause(): void;
    static scanImage(imageOrFileOrUrl: ImageSource, sourceRect?: Rect, worker?: QrWorker, canvas?: HTMLCanvasElement, fixedCanvasSize?: boolean, alsoTryWithoutSourceRect?: boolean): Promise<unknown>;
    setGrayscaleWeights(red: number, green: number, blue: number, useIntegerApproximation?: boolean): void;
    setInversionMode(inversionMode: "original" | "invert" | "both"): void;
    private _onCanPlay;
    private _onPlay;
    private _onVisibilityChange;
    private _updateSourceRect;
    private _scanFrame;
    private getCameraStream;
    private getMatchingCameraStream;
    private setVideoMirror;
}
export {};
