/// <reference types="jquery" />
import "bootstrap-notify";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiEntranceAnimation } from "../generated/UiEntranceAnimation";
import { UiExitAnimation } from "../generated/UiExitAnimation";
import { UiPageDisplayMode } from "../generated/UiPageDisplayMode";
import { UiNotification_Position } from "../generated/UiNotificationConfig";
import { UiColorConfig } from "../generated/UiColorConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiTextMatchingMode } from "../generated/UiTextMatchingMode";
export declare type RenderingFunction = (data: any) => string;
export declare type Renderer = {
    render: RenderingFunction;
    template: UiTemplateConfig;
};
export declare type ImageRenderer = (imageIdentifier: string) => string;
export declare class Constants {
    private static _SCROLLBAR_WIDTH;
    static ENTRANCE_ANIMATION_CSS_CLASSES: {
        [UiEntranceAnimation.LIGHTSPEED_IN]: string;
        [UiEntranceAnimation.ROLL_IN]: string;
        [UiEntranceAnimation.ZOOM_IN]: string;
        [UiEntranceAnimation.ZOOM_IN_DOWN]: string;
        [UiEntranceAnimation.ZOOM_IN_LEFT]: string;
        [UiEntranceAnimation.ZOOM_IN_RIGHT]: string;
        [UiEntranceAnimation.ZOOM_IN_UP]: string;
        [UiEntranceAnimation.SLIDE_IN_UP]: string;
        [UiEntranceAnimation.SLIDE_IN_DOWN]: string;
        [UiEntranceAnimation.SLIDE_IN_LEFT]: string;
        [UiEntranceAnimation.SLIDE_IN_RIGHT]: string;
        [UiEntranceAnimation.ROTATE_IN]: string;
        [UiEntranceAnimation.ROTATE_IN_DOWNLEFT]: string;
        [UiEntranceAnimation.ROTATE_IN_DOWNRIGHT]: string;
        [UiEntranceAnimation.ROTATE_IN_UPLEFT]: string;
        [UiEntranceAnimation.ROTATE_IN_UPRIGHT]: string;
        [UiEntranceAnimation.FLIP_IN_X]: string;
        [UiEntranceAnimation.FLIP_IN_Y]: string;
        [UiEntranceAnimation.FADE_IN]: string;
        [UiEntranceAnimation.FADE_IN_DOWN]: string;
        [UiEntranceAnimation.FADE_IN_DOWNBIG]: string;
        [UiEntranceAnimation.FADE_IN_LEFT]: string;
        [UiEntranceAnimation.FADE_IN_LEFTBIG]: string;
        [UiEntranceAnimation.FADE_IN_RIGHT]: string;
        [UiEntranceAnimation.FADE_IN_RIGHTBIG]: string;
        [UiEntranceAnimation.FADE_IN_UP]: string;
        [UiEntranceAnimation.FADE_IN_UPBIG]: string;
        [UiEntranceAnimation.BOUNCE_IN]: string;
        [UiEntranceAnimation.BOUNCE_IN_DOWN]: string;
        [UiEntranceAnimation.BOUNCE_IN_LEFT]: string;
        [UiEntranceAnimation.BOUNCE_IN_RIGHT]: string;
        [UiEntranceAnimation.BOUNCE_IN_UP]: string;
    };
    static EXIT_ANIMATION_CSS_CLASSES: {
        [UiExitAnimation.LIGHTSPEED_OUT]: string;
        [UiExitAnimation.ROLL_OUT]: string;
        [UiExitAnimation.HINGE]: string;
        [UiExitAnimation.ZOOM_OUT]: string;
        [UiExitAnimation.ZOOM_OUT_DOWN]: string;
        [UiExitAnimation.ZOOM_OUT_LEFT]: string;
        [UiExitAnimation.ZOOM_OUT_RIGHT]: string;
        [UiExitAnimation.ZOOM_OUT_UP]: string;
        [UiExitAnimation.SLIDE_OUT_UP]: string;
        [UiExitAnimation.SLIDE_OUT_DOWN]: string;
        [UiExitAnimation.SLIDE_OUT_LEFT]: string;
        [UiExitAnimation.SLIDE_OUT_RIGHT]: string;
        [UiExitAnimation.ROTATE_OUT]: string;
        [UiExitAnimation.ROTATE_OUT_DOWNLEFT]: string;
        [UiExitAnimation.ROTATE_OUT_DOWNRIGHT]: string;
        [UiExitAnimation.ROTATE_OUT_UPLEFT]: string;
        [UiExitAnimation.ROTATE_OUT_UPRIGHT]: string;
        [UiExitAnimation.FLIP_OUT_X]: string;
        [UiExitAnimation.FLIP_OUT_Y]: string;
        [UiExitAnimation.FADE_OUT]: string;
        [UiExitAnimation.FADE_OUT_DOWN]: string;
        [UiExitAnimation.FADE_OUT_DOWNBIG]: string;
        [UiExitAnimation.FADE_OUT_LEFT]: string;
        [UiExitAnimation.FADE_OUT_LEFTBIG]: string;
        [UiExitAnimation.FADE_OUT_RIGHT]: string;
        [UiExitAnimation.FADE_OUT_RIGHTBIG]: string;
        [UiExitAnimation.FADE_OUT_UP]: string;
        [UiExitAnimation.FADE_OUT_UPBIG]: string;
        [UiExitAnimation.BOUNCE_OUT]: string;
        [UiExitAnimation.BOUNCE_OUT_DOWN]: string;
        [UiExitAnimation.BOUNCE_OUT_LEFT]: string;
        [UiExitAnimation.BOUNCE_OUT_RIGHT]: string;
        [UiExitAnimation.BOUNCE_OUT_UP]: string;
    };
    static POINTER_EVENTS: {
        start: string;
        move: string;
        end: string;
    };
    static readonly SCROLLBAR_WIDTH: number;
    private static calculateScrollbarWidth;
}
export declare function hasVerticalScrollBar(element: HTMLElement): boolean;
export declare const matchingModesMapping: {
    [x in UiTextMatchingMode]: 'contains' | 'prefix' | 'prefix-word' | 'prefix-levenshtein' | 'levenshtein';
};
export declare function loadScriptAsynchronously(url: string, callback?: EventListener): void;
export interface ClickOutsideHandle {
    cancel: () => void;
}
export declare function doOnceOnClickOutsideElement(elements: JQuery, handler: (e?: JQueryMouseEventObject) => any, useCapture?: boolean): ClickOutsideHandle;
export declare type TreeEntry = any & {
    __children?: TreeEntry[];
    _isFreeTextEntry?: boolean;
};
export declare function buildTreeEntryHierarchy(entryList: any[], idPropertyName: string, parentIdPropertyName: string): TreeEntry[];
export declare type NodeWithChildren<T> = T & {
    __children?: NodeWithChildren<T>[];
};
export declare function buildObjectTree<T extends object>(nodes: T[], idPropertyName: string, parentIdPropertyName: string): NodeWithChildren<T>[];
export declare function humanReadableFileSize(bytes: number, decimalK?: boolean): string;
export declare function generateUUID(startingWithCharacter?: boolean): string;
export declare function formatNumber(number: number, precision: number, decimalSeparator: string, thousandsSeparator: string): string;
export declare function formatDecimalNumber(integerNumber: number, precision: number, decimalSeparator: string, thousandsSeparator: string): string;
export declare function applyDisplayMode($outer: JQuery, $inner: JQuery, displayMode: UiPageDisplayMode | any, options?: {
    innerPreferedDimensions?: {
        width: number;
        height: number;
    };
    zoomFactor?: number;
    padding?: number;
    considerScrollbars?: Boolean;
}): void;
export declare function enterFullScreen(component: UiComponent<UiComponentConfig> | JQuery | Element): void;
export declare function isFullScreen(): boolean;
export declare function exitFullScreen(): void;
export declare function hexColorStringToRgb(hexColorString: string): {
    r: number;
    g: number;
    b: number;
};
export declare function adjustIfColorTooBright(c: string, maxLuma256?: number): string;
export declare function positionDropDown($button: JQuery, $dropDown: JQuery, { viewPortPadding, minHeightBeforeFlipping }: {
    viewPortPadding?: number;
    minHeightBeforeFlipping?: number;
}): void;
export declare function manipulateWithoutTransitions($element: JQuery, action: Function, transitionEnabled?: boolean): void;
export declare function focusNextByTabIndex(navigatableElements: string | HTMLElement[] | JQuery, navDirection: -1 | 1): boolean;
export declare function escapeHtml(string: string): string;
export declare function capitalizeFirstLetter(string: string): string;
export declare function logException(e: any, additionalString?: string): void;
export declare function stableSort<T>(arr: T[], cmpFunc: (a: T, b: T) => number): T[];
export declare function showNotification(html: string, config?: {
    backgroundColor?: UiColorConfig;
    position?: UiNotification_Position;
    displayTimeInMillis?: number;
    dismissable?: boolean;
    showProgressBar?: boolean;
    entranceAnimation?: UiEntranceAnimation;
    exitAnimation?: UiExitAnimation;
}): void;
export declare function getMicrosoftBrowserVersion(): number | false;
export declare function getIconPath(context: TeamAppsUiContext, iconName: string, iconSize: number, ignoreRetina?: boolean): string;
export declare function enableScrollViaDragAndDrop($scrollContainer: JQuery): void;
export declare function arraysEqual(a: any[], b: any[]): boolean;
export declare function convertJavaDateTimeFormatToMomentDateTimeFormat(javaFormat: string): string;
export declare function insertAtIndex($parent: JQuery | Element, $child: JQuery | Element | string, index: number): void;
export declare function maximizeComponent(component: UiComponent, maximizeAnimationCallback?: () => void): (restoreAnimationCallback?: () => void) => void;
export declare function flattenArray<T>(array: (T | T[])[]): T[];
export declare function removeTags(value: string, ...tagNames: string[]): string;
export declare function removeDangerousTags(value: string): string;
export declare function selectElementContents(domElement: Node, start?: number, end?: number): void;
export declare function parseHtml<E extends HTMLElement>(htmlString: string): E;
export declare function prependChild(parent: Element, child: Element): void;
export declare function outerWidthIncludingMargins(el: HTMLElement): number;
export declare function closestAncestor(el: HTMLElement, selector: string, includeSelf?: boolean): HTMLElement;
export declare function isDescendantOf(child: Element, potentialAncestor: Element, includeSelf?: boolean): Node & ParentNode;
export declare function createImageThumbnailUrl(file: File): Promise<string>;
