import "shaka-player/dist/controls.css";
import "@less/components/UiShakaPlayer.less";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiShakaPlayer_EndedEvent, UiShakaPlayer_ErrorLoadingEvent, UiShakaPlayer_ManifestLoadedEvent, UiShakaPlayer_TimeUpdateEvent, UiShakaPlayerCommandHandler, UiShakaPlayerConfig, UiShakaPlayerEventSource } from "../generated/UiShakaPlayerConfig";
export declare class UiShakaPlayer extends AbstractUiComponent<UiShakaPlayerConfig> implements UiShakaPlayerCommandHandler, UiShakaPlayerEventSource {
    readonly onManifestLoaded: TeamAppsEvent<UiShakaPlayer_ManifestLoadedEvent>;
    readonly onTimeUpdate: TeamAppsEvent<UiShakaPlayer_TimeUpdateEvent>;
    readonly onEnded: TeamAppsEvent<UiShakaPlayer_EndedEvent>;
    readonly onErrorLoading: TeamAppsEvent<UiShakaPlayer_ErrorLoadingEvent>;
    private $componentWrapper;
    private $video;
    private player;
    private ui;
    constructor(config: UiShakaPlayerConfig, context: TeamAppsUiContext);
    private createUiManifest;
    private reconfigurePlayer;
    private reconfigureUi;
    private getOverflowMenuButtonsConfig;
    doGetMainElement(): HTMLElement;
    setTime(timeMillis: number): void;
    selectAudioLanguage(language: string, role: string): any;
    onResize(): void;
    destroy(): void;
    setUrls(hlsUrl: string, dashUrl: string): Promise<void>;
    static setDistinctManifestAudioTracksFixEnabled(enabled: boolean): void;
}
