import { EditingMode, RenderingFunction, TrivialComponent } from "./TrivialCore";
import { DropDownComponent } from "./dropdown/DropDownComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export interface TrivialComboBoxConfig<E> {
    /**
     * Rendering function used to display a _selected_ entry
     * (i.e. an entry inside the editor area of the component, not the dropdown).
     *
     * @param entry
     * @return HTML string
     * @default `wrapWithDefaultTagWrapper(entryRenderingFunction(entry))`
     */
    selectedEntryRenderingFunction: RenderingFunction<E>;
    /**
     * Whether or not to provide auto-completion.
     *
     * @default `true`
     */
    autoComplete?: boolean;
    /**
     * The number of milliseconds to wait until auto-completion is performed.
     *
     * @default `0`
     */
    autoCompleteDelay?: number;
    /**
     * Used to set the editor's text when focusing the component.
     * Additionally used to generate an autocompletion string for the current input of the user.
     *
     * @param entry the currently selected entry in the dropdown
     */
    entryToEditorTextFunction: (entry: E) => string;
    /**
     * Creates an entry (object) from a string entered by the user.
     *
     * @param freeText the text entered by the user
     * @default `{ displayValue: freeText, _isFreeTextEntry: true }`
     */
    textToEntryFunction?: (freeText: string) => E | any;
    /**
     * The clear button is a the small 'x' at the right of the entry display that can be clicked to clear the selection.
     */
    showClearButton?: boolean;
    /**
     * The trigger is the button on the right side of the component that can be clicket to open the dropdown.
     *
     * @default `true`
     */
    showTrigger?: boolean;
    editingMode?: EditingMode;
    /**
     * It `true`, opening the dropdown will be delayed until the result callback of the [[queryFunction]] is called.
     *
     * @default `false`
     */
    showDropDownOnResultsOnly?: boolean;
    /**
     * When typing, preselect the first returned query result.
     */
    preselectFirstQueryResult?: boolean;
    /**
     * Text displayed when nothing has been selected/typed.
     */
    placeholderText?: string;
}
export declare class TrivialComboBox<E> implements TrivialComponent {
    readonly onSelectedEntryChanged: TeamAppsEvent<E>;
    readonly onFocus: TeamAppsEvent<void>;
    readonly onBlur: TeamAppsEvent<void>;
    readonly onBeforeQuery: TeamAppsEvent<string>;
    readonly onBeforeDownOpens: TeamAppsEvent<string>;
    private config;
    private $comboBox;
    private $dropDown;
    private $editor;
    private $selectedEntryWrapper;
    private $trigger;
    private $clearButton;
    private popper;
    private dropDownComponent;
    private selectedEntry;
    private blurCausedByClickInsideComponent;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private editingMode;
    private dropDownOpen;
    private isEditorVisible;
    constructor(options: TrivialComboBoxConfig<E>, dropDownComponent?: DropDownComponent<E>);
    private getFreeTextEntry;
    private setAndSelectEditorValue;
    private handleDropDownValueChange;
    private query;
    private fireChangeEvents;
    setValue(entry: E, fireEventIfChanged?: boolean, originalEvent?: unknown): void;
    private isEntrySelected;
    private showEditor;
    private hideEditor;
    private parentElement;
    openDropDown(): void;
    closeDropDown(): void;
    private getEditorValueLeftOfSelection;
    private autoCompleteIfPossible;
    private isDropDownNeeded;
    setEditingMode(newEditingMode: EditingMode): void;
    getValue(): E;
    getDropDownComponent(): DropDownComponent<E>;
    setDropDownComponent(dropDownComponent: DropDownComponent<E>): void;
    focus(): void;
    getEditor(): Element;
    setShowClearButton(showClearButton: boolean): void;
    setShowTrigger(showTrigger: boolean): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): HTMLElement;
    setPlaceholderText(placeholderText: string): void;
}
