import { EditingMode, QueryFunction, TrivialComponent } from "./TrivialCore";
import { TrivialTreeBoxConfig } from "./TrivialTreeBox";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export interface TrivialUnitBoxConfig<U> extends TrivialTreeBoxConfig<U> {
    numberFormatFunction: (entry: U) => Intl.NumberFormat;
    unitDisplayPosition?: 'left' | 'right';
    allowNullAmount?: boolean;
    selectedEntryRenderingFunction: (entry: U) => string;
    amount?: number;
    queryFunction?: QueryFunction<U>;
    queryOnNonNumberCharacters?: boolean;
    openDropdownOnEditorClick?: boolean;
    showTrigger?: boolean;
    editingMode?: EditingMode;
}
export declare type TrivialUnitBoxChangeEvent<U> = {
    unitEntry: U;
    amount: string;
};
export declare class TrivialUnitBox<U> implements TrivialComponent {
    private config;
    readonly onChange: TeamAppsEvent<TrivialUnitBoxChangeEvent<U>>;
    readonly onSelectedEntryChanged: TeamAppsEvent<U>;
    readonly onFocus: TeamAppsEvent<void>;
    readonly onBlur: TeamAppsEvent<void>;
    private selectedEntry;
    private blurCausedByClickInsideComponent;
    private $editor;
    private $unitBox;
    private $selectedEntryAndTriggerWrapper;
    private $selectedEntryWrapper;
    private $dropDown;
    private $trigger;
    private usingDefaultQueryFunction;
    private numberParser;
    private popper;
    private dropDownComponent;
    private editingMode;
    private dropDownOpen;
    constructor(options: TrivialUnitBoxConfig<U>);
    private getNumberFormat;
    private getDecimalSeparator;
    private getThousandsSeparator;
    private getNumerals;
    private getMinFractionDigits;
    private getMaxFractionDigits;
    private getQueryString;
    private getEditorValueNumberPart;
    private toParsableNumber;
    private query;
    private fireSelectedEntryChangedEvent;
    private fireChangeEvents;
    setSelectedEntry(entry: U, fireEvent?: boolean, originalEvent?: unknown): void;
    private formatEditorValue;
    private cleanupEditorValue;
    private parentElement;
    openDropDown(): void;
    closeDropDown(): void;
    getAmount(): string;
    private isDropDownNeeded;
    setEditingMode(newEditingMode: EditingMode): void;
    getSelectedEntry(): U;
    setAmount(amount: string): void;
    focus(): void;
    getEditor(): Element;
    setUnitDisplayPosition(unitDisplayPosition: "left" | "right"): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): HTMLElement;
    private formatAmount;
}
