import { TeamAppsUiContextInternalApi } from "./TeamAppsUiContext";
import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { UiComponent } from "./UiComponent";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiEvent } from "../generated/UiEvent";
import { UiCommand } from '../generated/UiCommand';
import { TemplateRegistry } from "./TemplateRegistry";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare class DefaultTeamAppsUiContext implements TeamAppsUiContextInternalApi {
    private static logger;
    readonly onStaticMethodCommandInvocation: TeamAppsEvent<UiCommand>;
    readonly sessionId: string;
    isHighDensityScreen: boolean;
    config: UiConfigurationConfig;
    readonly templateRegistry: TemplateRegistry;
    private components;
    private _executingCommand;
    private connection;
    constructor(webSocketUrl: string, clientParameters?: {
        [key: string]: string | number;
    });
    readonly executingCommand: boolean;
    fireEvent(eventObject: UiEvent): void;
    registerComponent(component: UiComponent<UiComponentConfig>): void;
    createAndRegisterComponent(config: UiComponentConfig): UiComponent<UiComponentConfig>;
    destroyComponent(component: UiComponent): void;
    refreshComponent(config: UiComponentConfig): void;
    getComponentById(id: string): UiComponent<UiComponentConfig>;
    getIconPath(iconName: string, iconSize: number, ignoreRetina?: boolean): string;
    private executeCommands;
    private replaceComponentReferencesWithInstances;
    private commandExecutor;
    private executeCommand;
}
