import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiChatMessageConfig } from "../generated/UiChatMessageConfig";
import { UiChatDisplay_PreviousMessagesRequestedEvent, UiChatDisplayCommandHandler, UiChatDisplayConfig, UiChatDisplayEventSource } from "../generated/UiChatDisplayConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare class UiChatDisplay extends UiComponent<UiChatDisplayConfig> implements UiChatDisplayCommandHandler, UiChatDisplayEventSource {
    readonly onPreviousMessagesRequested: TeamAppsEvent<UiChatDisplay_PreviousMessagesRequestedEvent>;
    private $main;
    private gotFirstMessage;
    private requestingPreviousMessages;
    private chatMessages;
    private $loadingIndicatorWrapper;
    private $messages;
    constructor(config: UiChatDisplayConfig, context: TeamAppsUiContext);
    private requestPreviousMessages;
    getMainDomElement(): HTMLElement;
    addChatMessages(chatMessages: UiChatMessageConfig[], prepend: boolean, includesFirstMessage: boolean): void;
    replaceChatMessages(chatMessages: UiChatMessageConfig[], includesFirstMessage: boolean): void;
    private scrollToBottom;
    protected onAttachedToDom(): void;
    private getEarliestChatMessageId;
}
