import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiWindow } from "./UiWindow";
import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { UiNotificationConfig } from "../generated/UiNotificationConfig";
import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext, TeamAppsUiContextInternalApi } from "./TeamAppsUiContext";
import { UiRootPanelCommandHandler, UiRootPanelConfig } from "../generated/UiRootPanelConfig";
import { UiComponentRevealAnimation } from "../generated/UiComponentRevealAnimation";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiGenericErrorMessageOption } from "../generated/UiGenericErrorMessageOption";
import { UiColorConfig } from "../generated/UiColorConfig";
export declare class UiRootPanel extends UiComponent<UiRootPanelConfig> implements UiRootPanelCommandHandler {
    private static LOGGER;
    private static ALL_ROOT_PANELS_BY_ID;
    private static BACKGROUND_IMAGES_BY_ID;
    private static WINDOWS_BY_ID;
    private $root;
    private childComponentsById;
    private visibleChildComponent;
    private $backgroundTransitionStyle;
    private $backgroundStyle;
    private $imagePreloadDiv;
    private backgroundImage;
    private blurredBackgroundImage;
    private backgroundColor;
    static __initialize(): void;
    constructor(config: UiRootPanelConfig, context: TeamAppsUiContext);
    getMainDomElement(): HTMLElement;
    addChildComponent(component: UiComponent, show: boolean): void;
    setVisibleChildComponent(childComponentId: string, animation: UiComponentRevealAnimation | null, animationDuration: number): void;
    removeChildComponent(childComponentId: string): void;
    private readonly childComponents;
    static createComponent(config: UiComponentConfig, context: TeamAppsUiContextInternalApi): void;
    static destroyComponent(component: UiComponent, context: TeamAppsUiContextInternalApi): void;
    static refreshComponent(config: UiComponentConfig, context: TeamAppsUiContextInternalApi): void;
    static setConfig(config: UiConfigurationConfig, context: TeamAppsUiContext): void;
    static setPageTitle(pageTitle: string): void;
    private static readonly ALL_ROOT_PANELS;
    static registerBackgroundImage(id: string, image: string, blurredImage: string): void;
    static setBackgroundImage(id: string, animationDuration: number): void;
    static setBackgroundColor(backgroundColor: UiColorConfig, animationDuration: number): void;
    private updateBackground;
    static showWindow(uiWindow: UiWindow, animationDuration?: number, context?: TeamAppsUiContext): void;
    static removeWindow(windowId: string, animationDuration: number): void;
    onResize(): void;
    protected onAttachedToDom(): void;
    destroy(): void;
    static buildRootPanel(containerElementId: string, uiRootPanel: UiRootPanel, context?: TeamAppsUiContext): void;
    static setThemeClassName(theme: string): void;
    static showNotification(notification: UiNotificationConfig, context: TeamAppsUiContext): void;
    static downloadFile(fileUrl: string, fileName: string): boolean;
    static registerTemplate(name: string, template: UiTemplateConfig, context: TeamAppsUiContext): void;
    static registerTemplates(templates: {
        [name: string]: UiTemplateConfig;
    }, context: TeamAppsUiContext): void;
    static addClientToken(token: string): void;
    static removeClientToken(token: string): void;
    static clearClientTokens(): void;
    private static loadClientTokens;
    static getClientTokens(): string[];
    private static saveClientTokens;
    static exitFullScreen(): void;
    static showGenericErrorMessage(title: string, message: string, options: UiGenericErrorMessageOption[], context: TeamAppsUiContext): void;
    setOptimizedForTouch(optimizedForTouch: boolean): void;
}
