import * as d3 from "d3";
import { BaseType, Selection, ZoomBehavior } from "d3";
import { UiColorConfig } from '../generated/UiColorConfig';
import { UiComponent } from "./UiComponent";
import { UiTreeGraph_NodeClickedEvent, UiTreeGraph_NodeExpandedOrCollapsedEvent, UiTreeGraphCommandHandler, UiTreeGraphConfig, UiTreeGraphEventSource } from "../generated/UiTreeGraphConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiTreeGraphNodeConfig } from "../generated/UiTreeGraphNodeConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
export declare class UiTreeGraph extends UiComponent<UiTreeGraphConfig> implements UiTreeGraphCommandHandler, UiTreeGraphEventSource {
    readonly onNodeClicked: TeamAppsEvent<UiTreeGraph_NodeClickedEvent>;
    readonly onNodeExpandedOrCollapsed: TeamAppsEvent<UiTreeGraph_NodeExpandedOrCollapsedEvent>;
    private chart;
    private $main;
    constructor(config: UiTreeGraphConfig, context: TeamAppsUiContext);
    setNodes(nodes: UiTreeGraphNodeConfig[]): void;
    addNode(node: UiTreeGraphNodeConfig): void;
    removeNode(nodeId: string): void;
    setNodeExpanded(nodeId: string, expanded: boolean): void;
    setZoomFactor(zoomFactor: number): void;
    getMainDomElement(): HTMLElement;
    onResize(): void;
}
export interface Layouts {
    [key: string]: Function;
}
export interface NodeImage {
    url: string;
    width: number;
    height: number;
    centerTopDistance: number;
    centerLeftDistance: number;
    cornerShape: string;
    shadow: boolean;
    borderWidth: number;
    borderColor: UiColorConfig;
}
export interface NodeIcon {
    icon: string;
    size: number;
}
export interface TreeChartAttributes {
    [key: string]: any;
    id: string;
    data?: UiTreeGraphNodeConfig[];
    svgWidth?: number;
    svgHeight?: number;
    marginTop?: number;
    marginBottom?: number;
    marginRight?: number;
    marginLeft?: number;
    container?: any;
    defaultTextFill?: string;
    defaultFont?: string;
    backgroundColor: string;
    depth: number;
    duration: number;
    strokeWidth: number;
    dropShadowId: string;
    initialZoom: number;
    onNodeClick?: (name: string) => void;
    onNodeExpandedOrCollapsed?: (nodeId: string, expanded: boolean) => void;
}
export interface PatternifyParameter {
    selector: string;
    tag: string;
    data?: any;
}
export interface Behaviors {
    [key: string]: ZoomBehavior<SVGElement, void>;
}
export declare function patternify<E extends BaseType, ED, P extends BaseType = null, PD = null>(container: Selection<P, PD, any, any>, params: PatternifyParameter): d3.Selection<E, ED, P, PD>;
