import { UiWebRtcPublisher_PublishingFailedEvent, UiWebRtcPublisherCommandHandler, UiWebRtcPublisherConfig, UiWebRtcPublisherEventSource } from "../generated/UiWebRtcPublisherConfig";
import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiWebRtcPublishingSettingsConfig } from "../generated/UiWebRtcPublishingSettingsConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare class UiWebRtcPublisher extends UiComponent<UiWebRtcPublisherConfig> implements UiWebRtcPublisherCommandHandler, UiWebRtcPublisherEventSource {
    private static readonly PEER_CONNECTION_CONFIG;
    readonly onPublishingFailed: TeamAppsEvent<UiWebRtcPublisher_PublishingFailedEvent>;
    private $main;
    private $videoContainer;
    private video;
    private $audioActivityDisplayContainer;
    private $spinnerContainer;
    private publishingSettings;
    private publishingSignalingWsConnection;
    private publishingPeerConnection;
    private publishingUserData;
    private publishingIceConnectionState;
    private audioActivityDisplay;
    private multiStreamsMixer;
    private microphoneMuted;
    constructor(config: UiWebRtcPublisherConfig, context: TeamAppsUiContext);
    publish(settings: UiWebRtcPublishingSettingsConfig): void;
    setMicrophoneMuted(microphoneMuted: boolean): void;
    private getMediaStreamMixer;
    private static determineVideoSize;
    private reconnectForPublishing;
    unPublish(): void;
    private gotIceCandidate;
    private onPublishingIceConnectionStateChange;
    private updateUi;
    private addAudio;
    private addVideo;
    private enhanceSDP;
    private deliverCheckLine;
    private checkLine;
    private getRtpMapID;
    private errorHandler;
    setBackgroundImageUrl(backgroundImageUrl: string): void;
    onResize(): void;
    destroy(): void;
    getMainDomElement(): HTMLElement;
}
