import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiComponent } from "../UiComponent";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
import { UiButton_DropDownOpenedEvent, UiButtonCommandHandler, UiButtonConfig, UiButtonEventSource } from "../../generated/UiButtonConfig";
import { UiField } from "./UiField";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
export declare class UiButton extends UiField<UiButtonConfig, true> implements UiButtonEventSource, UiButtonCommandHandler {
    readonly onDropDownOpened: TeamAppsEvent<UiButton_DropDownOpenedEvent>;
    private template;
    private templateRecord;
    private _$button;
    private _dropDown;
    private dropDownComponent;
    private minDropDownWidth;
    private minDropDownHeight;
    private openDropDownIfNotSet;
    protected initialize(config: UiButtonConfig, context: TeamAppsUiContext): void;
    setDropDownSize(minDropDownWidth: number, minDropDownHeight: number): void;
    setDropDownComponent(component: UiComponent): void;
    private closeDropDown;
    private readonly dropDown;
    setOpenDropDownIfNotSet(openDropDownIfNotSet: boolean): void;
    getMainInnerDomElement(): HTMLElement;
    setTemplate(template: UiTemplateConfig, templateRecord: any): void;
    setTemplateRecord(data: any): void;
    private renderContent;
    setFieldMessages(fieldMessageConfigs: UiFieldMessageConfig[]): void;
    getFocusableElement(): HTMLElement;
    focus(): void;
    protected displayCommittedValue(): void;
    getTransientValue(): true;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: boolean, availableWidth: number): string;
    valuesChanged(v1: boolean, v2: boolean): boolean;
    doDestroy(): void;
    isValidData(v: boolean): boolean;
    getDefaultValue(): true;
}
