import { UiCurrencyValueConfig } from "../../generated/UiCurrencyValueConfig";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiCurrencyFieldConfig, UiCurrencyFieldCommandHandler, UiCurrencyFieldEventSource } from "../../generated/UiCurrencyFieldConfig";
import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export declare class UiCurrencyField extends UiField<UiCurrencyFieldConfig, UiCurrencyValueConfig> implements UiCurrencyFieldEventSource, UiCurrencyFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private trivialUnitBox;
    private $originalInput;
    private currencyCodeList;
    private showCurrencySymbol;
    private defaultCurrencyCode;
    private queryFunction;
    protected initialize(config: UiCurrencyFieldConfig, context: TeamAppsUiContext): void;
    isValidData(v: UiCurrencyValueConfig): boolean;
    private convertToTrivialComponentsEditingMode;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    hasFocus(): boolean;
    protected displayCommittedValue(): void;
    focus(): void;
    doDestroy(): void;
    getTransientValue(): UiCurrencyValueConfig;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: UiCurrencyValueConfig, availableWidth: number): string;
    getDefaultValue(): UiCurrencyValueConfig;
    setCurrencyCodeList(currencyCodeList: string[]): void;
    setShowCurrencyBeforeAmount(showCurrencyBeforeAmount: boolean): void;
    setShowCurrencySymbol(showCurrencySymbol: boolean): void;
    setDefaultCurrencyCode(defaultCurrencyCode: string): void;
    valuesChanged(v1: UiCurrencyValueConfig, v2: UiCurrencyValueConfig): boolean;
}
