import { UiTagComboBoxConfig, UiTagComboBoxCommandHandler, UiTagComboBoxEventSource } from "../../generated/UiTagComboBoxConfig";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComboBox_LazyChildDataRequestedEvent } from "../../generated/UiComboBoxConfig";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
import { UiComboBoxTreeRecordConfig } from "../../generated/UiComboBoxTreeRecordConfig";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
export declare class UiTagComboBox extends UiField<UiTagComboBoxConfig, UiComboBoxTreeRecordConfig[]> implements UiTagComboBoxEventSource, UiTagComboBoxCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    readonly onLazyChildDataRequested: TeamAppsEvent<UiComboBox_LazyChildDataRequestedEvent>;
    private $originalInput;
    private trivialTagComboBox;
    private templateRenderers;
    private lastResultCallback;
    private freeTextIdEntryCounter;
    protected initialize(config: UiTagComboBoxConfig, context: TeamAppsUiContext): void;
    private renderRecord;
    isValidData(v: any[]): boolean;
    setDropDownData(data: UiComboBoxTreeRecordConfig[]): void;
    setChildNodes(parentId: number, recordList: UiComboBoxTreeRecordConfig[]): void;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    protected displayCommittedValue(): void;
    getTransientValue(): any[];
    protected convertValueForSendingToServer(values: UiComboBoxTreeRecordConfig[]): any;
    focus(): void;
    hasFocus(): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    replaceFreeTextEntry(freeText: string, record: UiComboBoxTreeRecordConfig): void;
    doDestroy(): void;
    getReadOnlyHtml(records: UiComboBoxTreeRecordConfig[], availableWidth: number): string;
    getDefaultValue(): any[];
    valuesChanged(v1: UiComboBoxTreeRecordConfig[], v2: UiComboBoxTreeRecordConfig[]): boolean;
}
