/// <reference types="slickgrid" />
import { UiTableClientRecordConfig } from "../../generated/UiTableClientRecordConfig";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import DataProvider = Slick.DataProvider;
import { UiIdentifiableClientRecordConfig } from "../../generated/UiIdentifiableClientRecordConfig";
export declare class TableDataProvider implements DataProvider<UiTableClientRecordConfig> {
    onDataLoading: Slick.Event<unknown>;
    private dataStartIndex;
    private data;
    private recordById;
    private totalNumberOfRecords;
    getLength(): number;
    getItem(index: number): UiTableClientRecordConfig;
    getItemMetadata(index: number): Slick.RowMetadata<any>;
    updateData(startIndex: number, recordIds: number[], newRecords: UiIdentifiableClientRecordConfig[], totalNumberOfRecords: number): number[] | true;
    private calculateChangingRowNumbers;
    clear(): void;
    getRecordById(recordId: number): UiTableClientRecordConfig;
    getRowIndexByRecordId(recordId: number): number;
    setCellMessages(recordId: number, columnName: string, messages: UiFieldMessageConfig[]): void;
    clearAllCellMessages(): void;
    setCellMarked(recordId: any, columnName: string, marked: boolean): void;
    clearAllCellMarkings(): void;
    getSelectedRowsIndexes(): number[];
    setSelectedRows(rows: number[]): void;
}
