import { EditingMode, RenderingFunction, TrivialComponent } from "./TrivialCore";
import { DropDownComponent } from "./dropdown/DropDownComponent";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export interface TrivialTagComboBoxConfig<E> {
    /**
     * Rendering function used to display a _selected_ entry
     * (i.e. an entry inside the editor area of the component, not the dropdown).
     *
     * @param entry
     * @return HTML string
     * @default `wrapWithDefaultTagWrapper(entryRenderingFunction(entry))`
     */
    selectedEntryRenderingFunction: RenderingFunction<E>;
    /**
     * Performance setting. Defines the maximum number of entries until which text highlighting is performed.
     * Set to `0` to disable text highlighting.
     *
     * @default `100`
     */
    textHighlightingEntryLimit?: number;
    /**
     * Whether or not to provide auto-completion.
     *
     * @default `true`
     */
    autoComplete?: boolean;
    /**
     * The number of milliseconds to wait until auto-completion is performed.
     *
     * @default `0`
     */
    autoCompleteDelay?: number;
    /**
     * Used to set the editor's text when focusing the component.
     * Additionally used to generate an autocompletion string for the current input of the user.
     *
     * @param entry the currently selected entry in the dropdown
     */
    entryToEditorTextFunction: (entry: E) => string;
    /**
     * List of characters that, when entered by the user, trigger the creation of a tag/entry.
     *
     * @default `[",", ";"]`
     */
    freeTextSeparators?: string[];
    /**
     * Creates an entry (object) from a string entered by the user.
     *
     * @param freeText the text entered by the user
     * @default `{ displayValue: freeText, _isFreeTextEntry: true }`
     */
    freeTextEntryFactory?: (freeText: string) => E | any;
    /**
     * The trigger is the button on the right side of the component that can be clicket to open the dropdown.
     *
     * @default `true`
     */
    showTrigger?: boolean;
    editingMode?: EditingMode;
    /**
     * It `true`, opening the dropdown will be delayed until the result callback of the [[queryFunction]] is called.
     *
     * @default `false`
     */
    showDropDownOnResultsOnly?: boolean;
    /**
     * Function deciding whether an entry entered by the user is complete or not (partial).
     * A partial entry is an entry that needs more input from the user's side.
     *
     * @param entry
     * @return `true` if the entry is considered complete, `false` if not
     * @default always returns `true`
     */
    tagCompleteDecider?: (entry: E) => boolean;
    /**
     * Used to merge the current partial tag with the newly selected by the user.
     * (composite tags feature)
     *
     * @param partialEntry the current partial entry
     * @param newEntryPart the entry selected/entered by the user
     * @return a new entry that will replace the current partial entry. This may in turn be a partial or complete entry.
     * @default always returns the `newEntryPart`
     */
    entryMerger?: (partialEntry: E, newEntryPart: E) => E;
    /**
     * Whether or not a partial tag should be removed when the component
     * looses the focus.
     *
     * @default `true`
     */
    removePartialTagOnBlur?: boolean;
    /**
     * Decides whether the user's input/selection is accepted or not.
     * This can serve many purposes, including
     *  * implementing duplicate prevention
     *  * limiting the number of selectable tags
     *  * allowing or disallowing free text entries (this was previously possible using the now removed `allowFreeText` option)
     *  * allowing only free text entries of a certain form
     *  * ...
     *
     * @param entry the entry to be accepted or not
     * @return `true` if the entry is accepted, `false` if not
     * @default accepting all non-free-text entries
     */
    selectionAcceptor?: (entry: E) => boolean;
    /**
     * HTML string defining the spinner to be displayed while entries are being retrieved.
     */
    spinnerTemplate?: string;
    /**
     * This will cause tags to not directly be deleted when pressing the backspace or delete key, but first marked for deletion.
     */
    twoStepDeletion?: boolean;
    /**
     * When typing, preselect the first returned query result.
     */
    preselectFirstQueryResult?: boolean;
    /**
     * Text displayed when nothing has been selected/typed.
     */
    placeholderText?: string;
}
export declare class TrivialTagComboBox<E> implements TrivialComponent {
    readonly onValueChanged: TeamAppsEvent<E[]>;
    readonly onFocus: TeamAppsEvent<void>;
    readonly onBlur: TeamAppsEvent<void>;
    private config;
    private $tagComboBox;
    private $dropDown;
    private $placeholderText;
    private $editor;
    private $tagArea;
    private $trigger;
    private popper;
    private dropDownComponent;
    private selectedEntries;
    private tagToBeRemoved;
    private currentPartialTag;
    private blurCausedByClickInsideComponent;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private editingMode;
    private _isDropDownOpen;
    constructor(options: TrivialTagComboBoxConfig<E>, dropDownComponent?: DropDownComponent<E>);
    private setTagToBeRemoved;
    private cancelPartialTag;
    private findNearestTag;
    private removeTag;
    private query;
    private fireChangeEvents;
    private addTag;
    private repositionDropDown;
    private parentElement;
    openDropDown(): void;
    closeDropDown(): void;
    private getNonSelectedEditorValue;
    private autoCompleteIfPossible;
    private isDropDownNeeded;
    private doIgnoringBlurEvents;
    setEditingMode(newEditingMode: EditingMode): void;
    setSelectedEntries(entries: E[], forceAcceptance?: boolean): void;
    getSelectedEntries(): E[];
    getDropDownComponent(): DropDownComponent<E>;
    getCurrentPartialTag(): Tag<E>;
    focus(): void;
    getEditor(): Element;
    getDropDown(): HTMLElement;
    setShowClearButton(showClearButton: boolean): void;
    setShowTrigger(showTrigger: boolean): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): HTMLElement;
    private updatePlaceholderTextVisibility;
    private setPlaceholderText;
}
declare class Tag<E> {
    entry: E;
    $tagWrapper: HTMLElement;
    $entry: HTMLElement;
    constructor(entry: E, $tagWrapper: HTMLElement, $entry: HTMLElement);
}
export {};
