import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { TrivialCalendarBox } from "../TrivialCalendarBox";
import { LocalDateTime } from "../../datetime/LocalDateTime";
import { DropDownComponent, SelectionDirection } from "./DropDownComponent";
export declare class CalendarBoxDropdown implements DropDownComponent<LocalDateTime> {
    private calendarBox;
    private queryFunction;
    defaultDate: LocalDateTime;
    readonly onValueChanged: TeamAppsEvent<{
        value: LocalDateTime;
        finalSelection: boolean;
    }>;
    constructor(calendarBox: TrivialCalendarBox, queryFunction: (query: string) => Promise<LocalDateTime | null> | LocalDateTime | null, defaultDate: LocalDateTime);
    getMainDomElement(): HTMLElement;
    setValue(value: LocalDateTime): void;
    getValue(): LocalDateTime;
    handleKeyboardInput(event: KeyboardEvent): boolean;
    handleQuery(query: string, selectionDirection: SelectionDirection, currentComboBoxValue: LocalDateTime): Promise<boolean>;
    destroy(): void;
    getComponent(): TrivialCalendarBox;
}
