import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiCachedImageConfig } from "../generated/UiCachedImageConfig";
import { UiImageDisplay_ImageDisplayedEvent, UiImageDisplay_ImagesRequestEvent, UiImageDisplayCommandHandler, UiImageDisplayConfig, UiImageDisplayEventSource } from "../generated/UiImageDisplayConfig";
import { UiPageDisplayMode } from "../generated/UiPageDisplayMode";
export declare class UiImageDisplay extends AbstractUiComponent<UiImageDisplayConfig> implements UiImageDisplayCommandHandler, UiImageDisplayEventSource {
    readonly onImagesRequest: TeamAppsEvent<UiImageDisplay_ImagesRequestEvent>;
    readonly onImageDisplayed: TeamAppsEvent<UiImageDisplay_ImageDisplayedEvent>;
    private forwardImageSvg;
    private $componentWrapper;
    private $imageContainerWrapper;
    private $imageContainer;
    private $imageCacheContainer;
    private $backwardButton;
    private $forwardButton;
    private cachedImages;
    private totalNumberOfRecords;
    private zoomFactor;
    private displayMode;
    private currentImageIndex;
    constructor(config: UiImageDisplayConfig, context: TeamAppsUiContext);
    getMainDomElement(): HTMLElement;
    private jumpToNextImage;
    setCachedImages(startIndex: number, images: UiCachedImageConfig[], totalNumberOfRecords: number): void;
    showImage(id: string): void;
    private showImageByIndex;
    private findImageIndexById;
    setDisplayMode(displayMode: UiPageDisplayMode, zoomFactor: number): void;
    setZoomFactor(zoomFactor: number): void;
    private updateImageSizes;
    onResize(): void;
    destroy(): void;
}
