import { UiTextAlignment } from "../../generated/UiTextAlignment";
import { UiColorConfig } from "../../generated/UiColorConfig";
import { UiVerticalElementAlignment } from "../../generated/UiVerticalElementAlignment";
import { UiHorizontalElementAlignment } from "../../generated/UiHorizontalElementAlignment";
import { UiSizeType } from "../../generated/UiSizeType";
import { UiFontStyleConfig } from "../../generated/UiFontStyleConfig";
import { UiLineConfig } from "../../generated/UiLineConfig";
import { UiBorderConfig } from "../../generated/UiBorderConfig";
import { UiShadowConfig } from "../../generated/UiShadowConfig";
import { UiSpacingConfig } from "../../generated/UiSpacingConfig";
import { UiSizingPolicyConfig } from "../../generated/UiSizingPolicyConfig";
import { UiImageSizing } from "../../generated/UiImageSizing";
export declare type CssPropertyObject = {
    [cssProperty: string]: string;
};
export declare const cssUnitByUiSizeType: {
    [UiSizeType.FIXED]: string;
    [UiSizeType.FRACTION]: string;
    [UiSizeType.RELATIVE]: string;
};
export declare const cssHorizontalAlignmentByUiVerticalAlignment: {
    [UiHorizontalElementAlignment.LEFT]: string;
    [UiHorizontalElementAlignment.CENTER]: string;
    [UiHorizontalElementAlignment.RIGHT]: string;
    [UiHorizontalElementAlignment.STRETCH]: string;
};
export declare const cssVerticalAlignmentByUiVerticalAlignment: {
    [UiVerticalElementAlignment.TOP]: string;
    [UiVerticalElementAlignment.CENTER]: string;
    [UiVerticalElementAlignment.BOTTOM]: string;
    [UiVerticalElementAlignment.STRETCH]: string;
};
export declare function createUiColorCssString(uiColor: UiColorConfig): string;
export declare function createUiColorCssObject(cssProperty: string, uiColor: UiColorConfig): {
    [x: string]: string;
};
export declare function createTextAlignmentCssString(alignment: UiTextAlignment): string;
export declare function createUiFontStyleCssString(fontStyle: UiFontStyleConfig): string;
export declare function createUiLineCssString(lineConfig: UiLineConfig): string;
export declare function createUiBorderCssObject(borderConfig: UiBorderConfig): CssPropertyObject;
export declare function createUiBorderCssString(borderConfig: UiBorderConfig): string;
export declare function createUiShadowCssObject(shadowConfig: UiShadowConfig): CssPropertyObject;
export declare function createUiShadowCssString(shadowConfig: UiShadowConfig): string;
export declare function createImageSizingCssObject(imageSizing: UiImageSizing): CssPropertyObject;
export declare function createUiSpacingCssObject(cssProperty: string, spacingConfig: UiSpacingConfig): {
    [x: string]: string;
};
export declare function createUiSpacingCssString(cssProperty: string, spacingConfig: UiSpacingConfig): string;
export declare function createCssGridRowOrColumnString(sizePolicy: UiSizingPolicyConfig): string;
export declare function cssObjectToString(cssObject: CssPropertyObject): string;
