import { AbstractUiGraph } from "./AbstractUiGraph";
import { UiHoseGraphConfig } from "../../generated/UiHoseGraphConfig";
import { UiHoseGraphDataConfig } from "../../generated/UiHoseGraphDataConfig";
export declare class UiHoseGraph extends AbstractUiGraph<UiHoseGraphConfig, UiHoseGraphDataConfig> {
    private dropShadowFilterId;
    private static logger;
    private middleLine;
    private $middleLine;
    private lowerLine;
    private $lowerLine;
    private upperLine;
    private $upperLine;
    private area;
    private $area;
    private $defs;
    private $dots;
    private $yZeroLine;
    private upperLineDataStore;
    private middleLineDataStore;
    private lowerLineDataStore;
    private get dataStores();
    constructor(timeGraphId: string, config: UiHoseGraphConfig, dropShadowFilterId: string);
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: UiHoseGraphDataConfig): void;
    resetData(): void;
    getYDataBounds(xInterval: [number, number]): [number, number];
    private initLinesAndColorScale;
    private initDomNodes;
    doRedraw(): void;
    setConfig(lineFormat: UiHoseGraphConfig): void;
}
