import { EditingMode, TrivialComponent } from "./TrivialCore";
import { DateTime } from "luxon";
import DateTimeFormatOptions = Intl.DateTimeFormatOptions;
import { TeamAppsEvent } from "../util/TeamAppsEvent";
export interface TrivialDateTimeFieldConfig {
    locale?: string;
    timeZone?: string;
    dateFormat?: DateTimeFormatOptions;
    timeFormat?: DateTimeFormatOptions;
    autoComplete?: boolean;
    autoCompleteDelay?: number;
    showTrigger?: boolean;
    editingMode?: EditingMode;
    favorPastDates?: boolean;
}
export interface LocalTime {
    hour: number;
    minute: number;
    second?: number;
}
export declare class TrivialDateTimeField implements TrivialComponent {
    private config;
    private dateIconRenderer;
    private timeIconRenderer;
    private dateRenderer;
    private timeRenderer;
    readonly onChange: TeamAppsEvent<DateTime>;
    private dateListBox;
    private timeListBox;
    private calendarBox;
    private _isDropDownOpen;
    private value;
    private blurCausedByClickInsideComponent;
    private focusGoesToOtherEditor;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private calendarBoxInitialized;
    private editingMode;
    private dropDownMode;
    private $dateTimeField;
    private $dropDown;
    private popper;
    private $dateIconWrapper;
    private $dateEditor;
    private $timeIconWrapper;
    private $timeEditor;
    private $dropDownTargetElement;
    private $dateListBoxWrapper;
    private $timeListBoxWrapper;
    private $calendarBoxWrapper;
    private $activeEditor;
    private dateSuggestionEngine;
    private timeSuggestionEngine;
    constructor(options?: TrivialDateTimeFieldConfig);
    private updateRenderers;
    private isDropDownNeeded;
    private setDropDownMode;
    private getActiveBox;
    private getActiveEditor;
    private selectHighlightedListBoxEntry;
    private query;
    private queryDate;
    private queryTime;
    getValue(): DateTime;
    private fireChangeEvents;
    private setDate;
    private setTime;
    setValue(value: DateTime, fireEvent?: boolean): void;
    private updateDisplay;
    private repositionDropDown;
    openDropDown(): void;
    closeDropDown(): void;
    private getNonSelectedEditorValue;
    private autoCompleteIfPossible;
    setEditingMode(newEditingMode: EditingMode): void;
    setLocale(locale: string): void;
    setDateFormat(dateFormat: DateTimeFormatOptions): void;
    setTimeFormat(timeFormat: DateTimeFormatOptions): void;
    setLocaleAndFormats(locale: string, dateFormat: DateTimeFormatOptions, timeFormat: DateTimeFormatOptions): void;
    focus(): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): HTMLElement;
}
