import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { Emptyable } from "./util/Emptyable";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiSplitPane_SplitResizedEvent, UiSplitPaneCommandHandler, UiSplitPaneConfig, UiSplitPaneEventSource } from "../generated/UiSplitPaneConfig";
import { UiSplitSizePolicy } from "../generated/UiSplitSizePolicy";
import { UiSplitDirection } from "../generated/UiSplitDirection";
import { UiComponent } from "./UiComponent";
export declare class UiSplitPane extends AbstractUiComponent<UiSplitPaneConfig> implements Emptyable, UiSplitPaneCommandHandler, UiSplitPaneEventSource {
    readonly onSplitResized: TeamAppsEvent<UiSplitPane_SplitResizedEvent>;
    private _firstChildComponent;
    private _lastChildComponent;
    private _$splitPane;
    private _$firstChildContainerWrapper;
    private _$lastChildContainerWrapper;
    private _$firstChildContainer;
    private _$lastChildContainer;
    private _$dividerWrapper;
    private _$divider;
    private _sizeAttribute;
    private _minSizeAttribute;
    private _maxSizeAttribute;
    private _offsetAttribute;
    private _offsetSizeAttribute;
    referenceChildSize: number;
    sizePolicy: UiSplitSizePolicy;
    private firstChildMinSize;
    private lastChildMinSize;
    readonly onEmptyStateChanged: TeamAppsEvent<boolean>;
    constructor(config: UiSplitPaneConfig, context: TeamAppsUiContext);
    get splitDirection(): UiSplitDirection;
    doGetMainElement(): HTMLElement;
    private mousedownHandler;
    private createDragHandler;
    private pageXof;
    private pageYof;
    setFirstChild(firstChild: UiComponent<UiComponentConfig>): void;
    setLastChild(lastChild: UiComponent<UiComponentConfig>): void;
    private _updateChildContainerClasses;
    private _updatePositions;
    private isFirstEmpty;
    private isLastEmtpy;
    get firstChildComponent(): UiComponent<UiComponentConfig>;
    get lastChildComponent(): UiComponent<UiComponentConfig>;
    get id(): string;
    get empty(): boolean;
    setSize(referenceChildSize: number, sizePolicy: UiSplitSizePolicy): void;
    setFirstChildMinSize(firstChildMinSize: number): void;
    setLastChildMinSize(lastChildMinSize: number): void;
    private onChildEmptyStateChanged;
    private updateEmptyState;
}
