import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { TrivialComboBox } from "../../trivial-components/TrivialComboBox";
import { UiField } from "./../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { AbstractUiTimeFieldCommandHandler, AbstractUiTimeFieldConfig, AbstractUiTimeFieldEventSource } from "../../../generated/AbstractUiTimeFieldConfig";
import { UiDateTimeFormatDescriptorConfig } from "../../../generated/UiDateTimeFormatDescriptorConfig";
import { LocalDateTime } from "../../datetime/LocalDateTime";
export declare abstract class AbstractUiTimeField<C extends AbstractUiTimeFieldConfig, V> extends UiField<C, V> implements AbstractUiTimeFieldEventSource, AbstractUiTimeFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    protected trivialComboBox: TrivialComboBox<LocalDateTime>;
    protected timeRenderer: (time: LocalDateTime) => string;
    protected initialize(config: AbstractUiTimeFieldConfig, context: TeamAppsUiContext): void;
    protected abstract localDateTimeToString(entry: LocalDateTime): string;
    protected abstract createTimeRenderer(): (time: LocalDateTime) => string;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    focus(): void;
    hasFocus(): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    destroy(): void;
    getDefaultValue(): V;
    setLocaleAndTimeFormat(locale: string, timeFormat: UiDateTimeFormatDescriptorConfig): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
    setShowClearButton(showClearButton: boolean): void;
}
